<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_About_Img_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-about-img-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('About Image', 'bizmaster-core');
    }

    public function get_keywords()
    {
        return ['Section', 'About', 'Image', 'Title', "HugeBinary", 'Bizmaster'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-box';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'about_img', [
                'label' => esc_html__('About Image', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('About Img', 'bizmaster-core'),
                'default' => array(
					'url' => Utils::get_placeholder_image_src()
                )
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title Prefix', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('20+', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Years Experience', 'bizmaster-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();
		$repeater->add_control(
            'icon', [
                'label' => esc_html__('Social Icon', 'bizmaster-core'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'brands',
                ],
            ]
        );

        $repeater->add_control(
            'social_url',
            [
				'label' => esc_html__('Social Url', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('#', 'bizmaster-core')
			]
		);

        $this->add_control('social_items', [
            'label' => esc_html__('Social Items', 'bizmaster-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);

		$this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control('social_bg_color', [
            'label' => esc_html__('Social Bar BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-thumb3 .social-links" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('social_icon_color', [
            'label' => esc_html__('Social Icon Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-thumb3 .social-links a svg" => "fill: {{VALUE}}; color: {{VALUE}}"
            ]
        ]);

		$this->add_control('social_icon_hover_color', [
            'label' => esc_html__('Social Icon Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-thumb3 .social-links a:hover svg" => "fill: {{VALUE}}; color: {{VALUE}}"
            ]
        ]);

		$this->add_control('exp_bg_color', [
            'label' => esc_html__('Content BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-thumb3 .about-counter-wrap" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('exp_border_color', [
            'label' => esc_html__('Content Border Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-thumb3 .about-counter-wrap" => "border-color: {{VALUE}}"
            ]
        ]);

		$this->add_control('title_prefix_color', [
            'label' => esc_html__('Title Prefix Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-thumb3 .about-counter-wrap .about-counter" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Prefix Typography', 'bizmaster-core'),
            'name' => 'title_prefix_typography',
            'description' => esc_html__('Title Prefix Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .about-thumb3 .about-counter-wrap .about-counter"
        ]);

		$this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-thumb3 .about-counter-wrap .sec-desc" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'bizmaster-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .about-thumb3 .about-counter-wrap .sec-desc"
        ]);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$social_items = $settings['social_items'];
		?>
		<div class="about-thumb3">
			<div class="img1">
				<img src="<?php echo $settings['about_img']['url']; ?>">
			</div>
			<div class="about-counter-wrap jump-reverse">
				<h3 class="about-counter"><span class="counter-number"><?php echo $settings['title']; ?></span></h3>
				<p class="sec-desc"><?php echo $settings['subtitle']; ?></p>
			</div>
			<?php if(!empty($social_items)) { ?>
				<div class="social-links jump">
				<?php foreach($social_items as $social_item) { ?>
					<a href="<?php echo $social_item['social_url']; ?>" tabindex="-1">
						<?php Icons_Manager::render_icon($social_item['icon'], ['aria-hidden' => 'true']); ?>
					</a>
				<?php } ?>
				</div>
			<?php } ?>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_About_Img_Widget());
