<?php
/**
 * Elementor Widget
 * @package Fixturbo
 * @since 1.0.0
 */

namespace Elementor;
class Fixturbo_Accordion_One extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'fixturbo-accordion-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('BizMaster Accordion', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-accordion';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['fixturbo_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__('General Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control('acc_style', [
			'label' => esc_html__('Accordion Style', 'bizmaster-core'),
			'type' => Controls_Manager::SELECT,
			'options' => array(
				'one' => esc_html__('Accordion 1', 'bizmaster-core'),
				'two' => esc_html__('Accordion 2', 'bizmaster-core'),
				'three' => esc_html__('Accordion 3', 'bizmaster-core'),
			),
			'default' => 'one'
		]);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'title', [
				'label' => esc_html__('Title', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Data Entry Services', 'bizmaster-core')
			]
		);

        $repeater->add_control(
			'content_title', [
				'label' => esc_html__('Content', 'bizmaster-core'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('The decision comes amid accumulating warnings from scientists that human-caused climate change is increasing the likelihood of more severe floods, droughts, storms and other calamities.', 'bizmaster-core')
			]
		);

		$this->add_control('accordion_items', [
			'label' => esc_html__('Accordion Item', 'bizmaster-core'),
			'type' => Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls()
		]);

		$this->end_controls_section();

		$this->start_controls_section(
            'accordion_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control('accordion_card_background', [
            'label' => esc_html__('Accordion Card BG', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .accordion-card" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('active_accordion_card_background', [
            'label' => esc_html__('Active Accordion Card BG', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .accordion-card:has(.accordion-button:not(.collapsed))" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .accordion-card .accordion-button" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_control('active_title_color', [
            'label' => esc_html__('Active Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .accordion-card .accordion-button:not(.collapsed)" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Title Typography', 'bizmaster-core'),
			'name' => 'title_typography',
			'description' => esc_html__('Title Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .accordion-card .accordion-button"
		]);

		$this->add_control('content_color', [
            'label' => esc_html__('Content Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .accordion-card .accordion-collapse .accordion-body" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Content Typography', 'bizmaster-core'),
			'name' => 'content_typography',
			'description' => esc_html__('Content Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .accordion-card .accordion-collapse .accordion-body"
		]);

		$this->add_control('icon_bg_color', [
            'label' => esc_html__('Icon BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .accordion-card .accordion-button:after" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('icon_color', [
            'label' => esc_html__('Icon Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .accordion-card .accordion-button:after" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_control('active_icon_bg_color', [
            'label' => esc_html__('Active Icon BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .accordion-card .accordion-button:not(.collapsed):after" => "background: {{VALUE}}"
            ]
        ]);

        $this->add_control('active_icon_color', [
            'label' => esc_html__('Active Icon Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .accordion-card .accordion-button:not(.collapsed):after" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_responsive_control(
			'accordion_padding',
			[
				'label'      => esc_html__('Padding', 'bizmaster-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .accordion-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'accordion_margin',
			[
				'label'      => esc_html__('Margin', 'bizmaster-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .accordion-card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$accordion_items = $settings['accordion_items'];

		if($settings['acc_style'] == 'one') : ?>
			<div class="accordion-area accordion" id="eventAccordionOne">
				<?php $i = 0; ?>
				<?php foreach ($accordion_items as $item): ?>
                    <?php
						$j = '';
						$k = 'collapsed';
						$aria_expanded_one = false;
						$accordion_one = uniqid();
						if ($i == 0) {
							$j = 'show';
							$k = '';
							$aria_expanded_one = true;
						}
					?>
					<div class="accordion-card style3">
						<h2 class="accordion-header" id="heading-<?php echo $accordion_one . $i; ?>">
							<button class="accordion-button <?php echo $k; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo $accordion_one . $i; ?>" aria-expanded="<?php echo $aria_expanded_one; ?>" aria-controls="collapse-<?php echo $accordion_one . $i; ?>">
								<?php echo esc_html($item['title']); ?>
							</button>
						</h2>
						<div id="collapse-<?php echo $accordion_one . $i; ?>" class="accordion-collapse collapse <?php echo $j; ?>" aria-labelledby="heading-<?php echo $accordion_one . $i; ?>" data-bs-parent="#eventAccordionOne">
							<div class="accordion-body">
								<?php echo esc_html($item['content_title']); ?>
							</div>
						</div>
					</div>
					<?php $i++; ?>
				<?php endforeach; ?>
			</div>
		<?php elseif($settings['acc_style'] == 'two') : ?>
			<div class="accordion-area accordion" id="eventAccordionTwo">
				<?php $a = 0; ?>
				<?php foreach ($accordion_items as $item): ?>
                    <?php
                        $b = '';
						$c = 'collapsed';
						$aria_expanded_two = false;
						$accordion_two = uniqid();
						if ($a == 0) {
							$b = 'show';
							$c = '';
							$aria_expanded_two = true;
						}
					?>
					<div class="accordion-card style4">
						<h2 class="accordion-header" id="heading-<?php echo $accordion_two . $a; ?>">
							<button class="accordion-button <?php echo $c; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo $accordion_two . $a; ?>" aria-expanded="<?php echo $aria_expanded_two; ?>" aria-controls="collapse-<?php echo $accordion_two . $a; ?>">
								<?php echo esc_html($item['title']); ?>
							</button>
						</h2>
						<div id="collapse-<?php echo $accordion_two . $a; ?>" class="accordion-collapse collapse <?php echo $b; ?>" aria-labelledby="heading-<?php echo $accordion_two . $a; ?>" data-bs-parent="#eventAccordionTwo">
							<div class="accordion-body">
								<?php echo esc_html($item['content_title']); ?>
							</div>
						</div>
					</div>
					<?php $a++; ?>
				<?php endforeach; ?>
			</div>
		<?php elseif($settings['acc_style'] == 'three') : ?>
			<div class="accordion-area accordion" id="eventAccordionThree">
				<?php $a = 0; ?>
				<?php foreach ($accordion_items as $item): ?>
					<?php
                        $b = '';
						$c = 'collapsed';
						$aria_expanded_three = false;
						$accordion_three = uniqid();
						if ($a == 0) {
							$b = 'show';
							$c = '';
							$aria_expanded_three = true;
						}
					?>
					<div class="accordion-card">
						<h2 class="accordion-header" id="heading-<?php echo $accordion_three . $a; ?>">
							<button class="accordion-button <?php echo $c; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo $accordion_three . $a; ?>" aria-expanded="<?php echo $aria_expanded_three; ?>" aria-controls="collapse-<?php echo $accordion_three . $a; ?>">
								<?php echo esc_html($item['title']); ?>
							</button>
						</h2>
						<div id="collapse-<?php echo $accordion_three . $a; ?>" class="accordion-collapse collapse <?php echo $b; ?>" aria-labelledby="heading-<?php echo $accordion_three . $a; ?>" data-bs-parent="#eventAccordionThree">
							<div class="accordion-body">
								<?php echo esc_html($item['content_title']); ?>
							</div>
						</div>
                    </div>
					<?php $a++; ?>
				<?php endforeach; ?>
			</div>
		<?php else : ?>
			<h4><?php _e( 'Please Select Accordion Style', 'bizmaster-core' ); ?></h4>
		<?php endif; ?>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Fixturbo_Accordion_One());
