<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Banner_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-theme-banner-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner: One', 'bizmaster-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Banner', 'Title', "HugeBinary", 'Bizmaster'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-banner';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    
    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'banner_one_content_settings_section',
            [
                'label' => esc_html__('Content Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'banner_bg_image', [
                'label' => esc_html__('Bg Image', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Bg image', 'bizmaster-core')
            ]
        );

        $this->add_control(
            'shape_image', [
                'label' => esc_html__('Shape Image', 'bizmaster-core'),
                'type' => Controls_Manager::ICONS,
                'show_label' => false,
                'description' => esc_html__('Upload Shape Icon', 'bizmaster-core'),
                'default' => [
                    'value' => 'fas fa-play',
                    'library' => 'solid',
                ]
            ]
        );

        $this->add_control(
            'banner_shape_title',
            [
                'label' => esc_html__('Banner Shape Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Growth Accel erato', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'banner_title',
            [
                'label' => esc_html__('Sub Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Growth Accelerator', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'banner_one_description',
            [
                'label' => esc_html__('Description', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter  description.', 'bizmaster-core'),
                'default' => esc_html__('A business consultant is a professional who provides expert advice and guidance to businesses on various aspects such', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'banner_one_btn_text',
            [
                'label' => esc_html__('Btn Text', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Learn More', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'button-arrow', [
                'label' => esc_html__('Button Arrow', 'bizmaster-core'),
                'type' => Controls_Manager::ICONS,
                'show_label' => false,
                'description' => esc_html__('Upload Arrow', 'bizmaster-core'),
                'default' => [
                    'value' => 'fas fa-play',
                    'library' => 'solid',
                ]
            ]
        );

        $this->add_control(
            'banner_one_btn_url',
            [
                'label' => esc_html__('Btn Url', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'banner_one_btn_two_text',
            [
                'label' => esc_html__('Btn Text', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Our Services', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'banner_one_btn_two_url',
            [
                'label' => esc_html__('Btn Url', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'banner_right_image', [
                'label' => esc_html__('Right Image', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Right image', 'bizmaster-core')
			]
        );

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
            'card-image', [
				'label'       => esc_html__( 'Card Image', 'bizmaster-core' ),
				'type'        => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-play',
					'library' => 'solid'
				],
				'description' => esc_html__( 'Upload Card Image', 'bizmaster-core' )
			]
        );

		$repeater->add_control(
            'card-title', [
				'label'       => esc_html__( 'Card Title', 'bizmaster-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => 'Growth Acceler',
				'label_block' => true,
				'description' => esc_html__( 'Add Card Title', 'bizmaster-core' )
			]
		);

		$repeater->add_control(
            'card-content', [
				'label'       => esc_html__( 'Slide Content', 'bizmaster-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => 'A business consultant',
				'label_block' => true,
				'description' => esc_html__( 'Add Slide Sub Title', 'bizmaster-core' )
			]
		);

		$this->add_control('heroLists', [
			'label'		=> esc_html__( 'Hero Card', 'bizmaster-core' ),
			'type'		=> Controls_Manager::REPEATER,
			'fields'	=> $repeater->get_controls()
		]);

		$this->end_controls_section();

        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('subtitle_color', [
			'label' => esc_html__('Sub Title Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
                "{{WRAPPER}} .sub-title" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Sub Title Typography', 'bizmaster-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Sub Title Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .sub-title"
        ]);
        $this->add_control('title_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'selectors' => [
                "{{WRAPPER}} .hero-title" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('title Typography', 'bizmaster-core'),
            'name' => 'title_typography',
            'description' => esc_html__('title typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .hero-title"
        ]);
        $this->add_control('description_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('description Color', 'bizmaster-core'),
            'selectors' => [
                "{{WRAPPER}} .hero-text" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('description Typography', 'bizmaster-core'),
            'name' => 'description_typography',
            'description' => esc_html__('description typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .hero-text"
        ]);
        $this->add_control('btn_one_bg_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Btn One Bg Color', 'bizmaster-core'),
            'selectors' => [
                "{{WRAPPER}} .hero-style1 .global-btn-one" => "background: {{VALUE}}",
            ]
        ]);
        $this->add_control('btn_two_bg_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Btn two Bg Color', 'bizmaster-core'),
            'selectors' => [
                "{{WRAPPER}} .hero-style1 .global-btn-two" => "background: {{VALUE}}",
            ]
        ]);
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $heroLists = $settings['heroLists'];
        ?>

		<div class="hero-wrapper bg-smoke hero-1" id="hero" style="background-image: url('<?php echo $settings['banner_bg_image']['url']; ?>');">
			<div class="container">
				<div class="row align-items-end">
					<div class="col-xl-6">
						<div class="hero-style1">
							<?php if(!empty($settings['banner_shape_title'])) { ?>
								<span class="sub-title">
									<?php Icons_Manager::render_icon($settings['shape_image'], ['aria-hidden' => 'true']); ?>
									<?php echo $settings['banner_shape_title']; ?>
								</span>
							<?php } ?>
							<?php if(!empty($settings['banner_title'])) { ?>
								<h1 class="hero-title"><?php echo $settings['banner_title']; ?></h1>
							<?php } ?>
							<?php if(!empty($settings['banner_one_description'])) { ?>
								<p class="hero-text"><?php echo $settings['banner_one_description']; ?></p>
							<?php } ?>
							<div class="btn-group">
								<?php if(!empty($settings['banner_one_btn_text'])) { ?>
									<a href="<?php echo $settings['banner_one_btn_url']; ?>" class="global-btn global-btn-one">
										<?php echo $settings['banner_one_btn_text']; ?> 
										<?php Icons_Manager::render_icon($settings['button-arrow'], ['aria-hidden' => 'true']); ?>
									</a>
								<?php } ?>
								<?php if(!empty($settings['banner_one_btn_two_text'])) { ?>
									<a href="<?php echo $settings['banner_one_btn_two_url']; ?>" class="global-btn global-btn-two style-border">
										<?php echo $settings['banner_one_btn_two_text']; ?>
									</a>
								<?php } ?>
							</div>
						</div>
					</div>
					<div class="col-xl-6">
						<div class="hero-image-wrapp">
							<div class="hero-thumb text-center">
								<?php if(!empty($settings['banner_right_image']['url'])) { ?>
									<img src="<?php echo $settings['banner_right_image']['url']; ?>" alt="img">
								<?php } ?>
							</div>
							<div class="hero-shape1"></div>
							<div class="hero-shape2"></div>
							<div class="hero-shape3"></div>
							<div class="hero-shape4"></div>
							<div class="hero-shape5 spin"></div>
						</div>
					</div>
				</div>
				<div class="hero-item-content">
					<div class="hero-card_wrapper">
						<?php foreach ( $heroLists as $item ): ?>
							<div class="hero-card">
								<div class="hero-card_icon">
									<?php Icons_Manager::render_icon($item['card-image'], ['aria-hidden' => 'true']); ?>
								</div>
								<div class="hero-card_content">
									<h4 class="box-title"><?php echo esc_html( $item['card-title'] ); ?></h4>
									<p class="hero-card_text"><?php echo esc_html( $item['card-content'] ); ?></p>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		</div>
	<?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Banner_One_Widget());
