<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Banner_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-theme-banner-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner Two', 'bizmaster-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Banner', 'Title', "HugeBinary", 'Bizmaster'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-banner';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'banner_two_content_settings_section',
            [
                'label' => esc_html__('Content Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'banner_bg',
            [
                'label'		=> esc_html__('Banner Bg Img', 'vaptek-core'),
                'type'		=> Controls_Manager::MEDIA,
				'default'	=> [
					'url' => Utils::get_placeholder_image_src()
				]
			]
        );

        $this->add_control(
            'overlay_bg',
            [
                'label' => esc_html__('Banner Overlay img', 'vaptek-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'banner_two_title',
            [
                'label' => esc_html__('Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Empowering', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'banner_two_title_color',
            [
                'label' => esc_html__('Banner Color Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('businesses', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'banner_two_title_two',
            [
                'label' => esc_html__('Title Two', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('brighter', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'banner_two_description',
            [
                'label' => esc_html__('Description', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter  description.', 'bizmaster-core'),
                'default' => esc_html__('We have been operating for over a decade, providing top-notch services to our clients and building strong track reco industry been operating', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'banner_two_btn_text',
            [
                'label' => esc_html__('Btn Text', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Learn More', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'button-arrow', [
                'label' => esc_html__('Button Arrow', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Arrow', 'bizmaster-core')
			]
        );

        $this->add_control(
            'banner_two_btn_url',
            [
                'label' => esc_html__('Btn Url', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'banner_video_url',
            [
                'label' => esc_html__('Video Btn Url', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('//www.youtube.com/watch?v=P7fi4hP_y80', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'video_text',
            [
                'label' => esc_html__('Video Text', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('See How It Works', 'bizmaster-core'),
            ]
        );
		
		
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
            'card-image', [
				'label'       => esc_html__( 'Client Image', 'bizmaster-core' ),
				'type'		=> Controls_Manager::MEDIA,
				'default'	=> [ 'url' => Utils::get_placeholder_image_src() ],
				'description' => esc_html__( 'Upload Client Image', 'bizmaster-core' )
			]
		);

		$this->add_control('clientThumb', [
			'label'		=> esc_html__( 'Hero Client Thumb', 'bizmaster-core' ),
			'type'		=> Controls_Manager::REPEATER,
			'fields'	=> $repeater->get_controls()
		]);

        $this->add_control(
            'counter_more_text',
            [
                'label' => esc_html__('More Text', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('More', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'counter_number',
            [
                'label' => esc_html__('Count Number', 'bizmaster-core'),
                'type' => Controls_Manager::NUMBER,
                'default' => esc_html__('650', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'counter_count',
            [
                'label' => esc_html__('Count', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('K', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'author_review',
            [
                'label' => esc_html__('Author Review', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Author Reviews', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'author_review_color',
            [
                'label' => esc_html__('Author Review Color', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('(4.8 of 5)', 'bizmaster-core'),
            ]
        );

        $this->end_controls_section();

        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('title_action_color', [
            'label' => esc_html__('Title Action Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .hero-style2 .hero-title .hero-title2" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'bizmaster-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .hero-style2 .hero-title"
        ]);

        $this->add_control('btn_bg_color', [
            'label' => esc_html__('Btn Bg Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .hero-style2 .global-btn" => "background: {{VALUE}}"
            ]
        ]);

        $this->add_control('video_bg_color', [
            'label' => esc_html__('Video Bg', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .media-wrap .icon" => "background: {{VALUE}}"
            ]
        ]);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clientThumb = $settings['clientThumb'];
        ?>

		<!-- my -->
        <div class="hero-wrapper hero-2" id="hero" style="background-image: url(<?php echo $settings['banner_bg']['url']; ?>);">
            <div class="hero-overlay" style="background-image: url(<?php echo $settings['overlay_bg']['url']; ?>);"> </div>
			<div class="container">
                <div class="hero-style2">
                    <h1 class="hero-title text-white"><?php echo $settings['banner_two_title']; ?><span class="hero-title2"><?php echo $settings['banner_two_title_color']; ?></span> <?php echo $settings['banner_two_title_two']; ?></h1>
                    <p class="hero-text text-white"><?php echo $settings['banner_two_description']; ?></p>
                    <div class="btn-group">
						<?php if(!empty($settings['banner_two_btn_text'])) { ?>
							<a href="<?php echo $settings['banner_two_btn_url']; ?>" class="global-btn">
								<?php echo $settings['banner_two_btn_text']; ?>
								<?php if(!empty($settings['button-arrow']['url'])) { ?>
									<img src="<?php echo $settings['button-arrow']['url']; ?>" alt="">
								<?php } ?>
							</a>
						<?php } ?>
						<?php if(!empty($settings['banner_video_url'])) { ?>
							<div class="media-wrap">
								<div class="icon">
									<a href="<?php echo $settings['banner_video_url']; ?>" class="play-btn popup-video"><i class="fas fa-solid fa-play"></i> </a>
								</div>
								<?php if(!empty($settings['video_text'])) { ?>
									<div class="media-body">
										<h6 class="title text-white"><?php echo $settings['video_text']; ?></h6>
									</div>
								<?php } ?>
							</div>
						<?php } ?>
					</div>
                </div>
                <div class="hero-client-box">
                    <div class="client-thumb">
                        <div class="client-thumb-group">
							<?php foreach ( $clientThumb as $item ): ?>
								<div class="thumb"><img src="<?php echo esc_url( $item['card-image']['url'] ); ?>" alt="avater"></div>
							<?php endforeach; ?>
                        </div>
                        <div class="client-box-content">
                            <div class="client-box_wrapp">
                                <h4 class="cilent-box_counter"><?php echo $settings['counter_more_text'] ?> <span class="counter-number"><?php echo $settings['counter_number'] ?></span> <?php echo $settings['counter_count'] ?></h4>
                                <i class="fas fa-check"></i>
                            </div>
                            <span class="cilent-box_title"><?php echo $settings['author_review'] ?> <span class="text-theme"><?php echo $settings['author_review_color'] ?></span> </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Banner_Two_Widget());