<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Cta_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-cta-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('CTA', 'bizmaster-core');
    }

    public function get_keywords()
    {
        return ['Section', 'CTA', 'Title', "HugeBinary", 'Bizmaster'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-call-to-action';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }
    
    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
			'banner_one_content_settings_section',
			[
				'label' => esc_html__('Content Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__('Title', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Let’s Do Great!', 'bizmaster-core')
			]
		);

		$this->add_control(
			'content',
			[
				'label' => esc_html__('Content', 'bizmaster-core'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Dictum ultrices porttitor amet nec sollicitudin mi molestie', 'bizmaster-core')
			]
		);

        $this->add_control(
			'btn_text',
			[
				'label' => esc_html__('Button Text', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Learn More', 'bizmaster-core')
			]
		);

		$this->add_control(
			'btn_url',
			[
				'label' => esc_html__( 'Button Url', 'bizmaster-core' ),
				'type' => Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false
				],
				'label_block' => true
			]
		);

        $this->add_control(
			'title_2',
			[
				'label' => esc_html__('Title 2', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Our Services', 'bizmaster-core')
			]
		);

        $this->add_control(
			'subtitle_2',
			[
				'label' => esc_html__('Sub Title 2', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Worldwide clients', 'bizmaster-core')
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
            'image', [
				'label'	=> esc_html__( 'Card Image', 'bizmaster-core' ),
				'type'	=> Controls_Manager::MEDIA,
				'default'	=> array( 'url' => Utils::get_placeholder_image_src() ),
				'description' => esc_html__( 'upload image', 'bizmaster-core' ),
				'show_label' => false
			]
		);

		$this->add_control('imagelist', [
            'label' => esc_html__('Image List', 'bizmaster-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls()
		]);

		$this->end_controls_section();

        //Style tab style
		$this->start_controls_section(
			'style_settings_section',
			[
				'label' => esc_html__('Style Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control('left_side_bg_color', [
			'label' => esc_html__('Left Side BG Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .cta-wrap1:before" => "background: {{VALUE}}"
			]
		]);

        $this->add_control('left_title_color', [
			'label' => esc_html__('Left Side Title Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .cta-wrap1 .title-area .sec-title" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Left Side Title Typography', 'bizmaster-core'),
			'name' => 'left_title_typography',
			'description' => esc_html__('Left Side Title Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .cta-wrap1 .title-area .sec-title"
		]);

		$this->add_control('left_content_color', [
			'label' => esc_html__('Left Side Content Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .cta-wrap1 .title-area .cta-desc" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Left Side Content Typography', 'bizmaster-core'),
			'name' => 'left_content_typography',
			'description' => esc_html__('Left Side Content Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .cta-wrap1 .title-area .cta-desc"
		]);

        $this->add_control('right_side_bg_color', [
			'label' => esc_html__('Right Side BG Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .cta-wrap1:after" => "background: {{VALUE}}"
			]
		]);

		$this->add_control('right_title_color', [
			'label' => esc_html__('Title 2 Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .cta-wrap1 .cilent-box_counter" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Title 2 Typography', 'bizmaster-core'),
			'name' => 'right_title_typography',
			'description' => esc_html__('Left Side Title Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .cta-wrap1 .cilent-box_counter"
		]);

		$this->add_control('right_subtitle_color', [
			'label' => esc_html__('Sub Title 2 Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .cta-wrap1 .cilent-box_title" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Sub Title 2 Typography', 'bizmaster-core'),
			'name' => 'right_subtitle_typography',
			'description' => esc_html__('Sub Title 2 Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .cta-wrap1 .cilent-box_title"
		]);

		$this->add_control('btn_bg_color', [
            'label' => esc_html__('Button BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .cta-wrap1 .global-btn.style-border" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('btn_bg_hover_color', [
            'label' => esc_html__('Button BG Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .cta-wrap1 .global-btn.style-border:after" => "background: {{VALUE}}",
				"{{WRAPPER}} .cta-wrap1 .global-btn.style-border:before" => "background: {{VALUE}}"
			]
        ]);

		$this->add_control('btn_color', [
            'label' => esc_html__('Button Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .cta-wrap1 .global-btn.style-border" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_control('btn_hover_color', [
            'label' => esc_html__('Button Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
				"{{WRAPPER}} .cta-wrap1 .global-btn.style-border:hover" => "color: {{VALUE}}"
			]
		]);

		$this->add_control('btn_border_color', [
            'label' => esc_html__('Button Border Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
				"{{WRAPPER}} .cta-wrap1 .global-btn.style-border" => "border-color: {{VALUE}}"
			]
		]);

		$this->add_control('btn_border_hover_color', [
            'label' => esc_html__('Button Border Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
				"{{WRAPPER}} .cta-wrap1 .global-btn.style-border:hover" => "border-color: {{VALUE}}"
			]
		]);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
		$settings = $this->get_settings_for_display();
		$imagelist = $settings['imagelist'];
		?>
		<div class="cta-area-1">
			<div class="container">
				<div class="cta-wrap1">
					<div class="row gy-4 justify-content-md-between align-items-center">
						<div class="col-lg-6 col-md-8">
							<div class="title-area mb-md-0">
								<h2 class="sec-title style2 mb-4"><?php echo $settings['title']; ?></h2>
								<p class="cta-desc mb-0"><?php echo $settings['content']; ?></p>
							</div>
						</div>
						<div class="col-lg-6">
							<div class="client-box justify-content-between mb-sm-0 mb-5">
								<div class="client-thumb">
									<div class="client-thumb-group">
										<?php foreach ( $imagelist as $item ): ?>
											<div class="thumb">
												<img src="<?php echo $item['image']['url']; ?>" alt="<?php echo $settings['title']; ?>">
											</div>
										<?php endforeach; ?>
										<div class="thumb icon"><i class="fas fa-plus"></i></div>
									</div>
									<div class="client-box-content">
										<h4 class="cilent-box_counter"><?php echo $settings['title_2']; ?></h4>
										<span class="cilent-box_title"><?php echo $settings['subtitle_2']; ?></span>
									</div>
								</div>
								<?php if(!empty($settings['btn_text'])) : ?>
									<?php
										if ( ! empty( $settings['btn_url']['url'] ) ) {
											$this->add_link_attributes( 'btn_url', $settings['btn_url'] );
										}
									?>
									<div class="cta-btn">
										<a class="global-btn style-border" <?php $this->print_render_attribute_string( 'btn_url' ); ?>>
											<?php echo $settings['btn_text']; ?>
										</a>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Cta_Widget());
