<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Section_Title_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-theme-section-title-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Heading Title: 01', 'bizmaster-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Heading', 'Title', "HugeBinary", 'Bizmaster'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-heading';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'shape_image', [
                'label' => esc_html__('Shape Image', 'bizmaster-core'),
                'type' => Controls_Manager::ICONS,
                'show_label' => false,
                'description' => esc_html__('Upload Shape', 'bizmaster-core'),
                'default' => [
                    'value' => 'fas fa-play',
                    'library' => 'solid',
                ]
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Sub Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Latest service', 'bizmaster-core'),
                'description' => esc_html__('enter title. use {c} color text {/c} for color text', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Empowering Business The Excellence', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => esc_html__('Content', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label' => esc_html__('Alignment', 'bizmaster-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'bizmaster-core'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'bizmaster-core'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'bizmaster-core'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    "{{WRAPPER}} .title-area" => "text-align: {{VALUE}}"
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Styling Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('subtitle_color', [
            'label' => esc_html__('Sub Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .sub-title" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Sub Title Typography', 'bizmaster-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Sub Title typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .sub-title"
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .sec-title" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('title Typography', 'bizmaster-core'),
            'name' => 'title_typography',
            'description' => esc_html__('title typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .sec-title"
        ]);

        $this->add_control('content_color', [
            'label' => esc_html__('content Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .sec-text" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('content Typography', 'bizmaster-core'),
            'name' => 'content_typography',
            'description' => esc_html__('content typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .sec-text"
        ]);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="title-area">
            <?php if (!empty($settings['subtitle'])) : ?>
            <span class="sub-title">
                <?php 
                Icons_Manager::render_icon($settings['shape_image'], ['aria-hidden' => 'true']);
                
                $subtitle = str_replace(['{c}', '{/c}'], ['<span>', '</span>'], $settings['subtitle']);
                print wp_kses($subtitle, bizmaster_core()->kses_allowed_html('all'));
                ?>  
            </span>
            <?php endif; ?>
            <h2 class="sec-title style2">
            <?php
                $title = str_replace(['{c}', '{/c}'], ['<span>', '</span>'], $settings['title']);
                print wp_kses($title, bizmaster_core()->kses_allowed_html('all'));
            ?>
            </h2>
            <?php
                if(!empty($settings['content'])){ ?>
                    <p class="sec-text"><?php echo $settings['content']; ?></p>
                <?php }
            ?>

        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Section_Title_One_Widget());