<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Line_Progress_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-line-progress-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Line Progress', 'bizmaster-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Line', 'Progress', 'Title', "HugeBinary", 'Bizmaster'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-skill-bar';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__('General Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__('Title', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Last mile delivery', 'bizmaster-core')
			]
		);

        $this->add_control(
			'value',
			[
				'label' => esc_html__('Value', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('80', 'bizmaster-core')
			]
		);

		$this->end_controls_section();

		/*  tab styling tabs start */
		$this->start_controls_section(
			'style_settings_section',
			[
				'label' => esc_html__('Style Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control('title_color', [
			'label' => esc_html__('Title Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .skill-feature .skill-feature_title" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Title Typography', 'bizmaster-core'),
			'name' => 'title_typography',
			'description' => esc_html__('Title Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .skill-feature.style2 .skill-feature_title"
		]);

		$this->add_control('counter_color', [
			'label' => esc_html__('Counter Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .skill-feature.style2 .progress .progress-value" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Counter Typography', 'bizmaster-core'),
			'name' => 'counter_typography',
			'description' => esc_html__('Counter Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .skill-feature.style2 .progress .progress-value"
		]);

		$this->add_control('progress_bar_color', [
            'label' => esc_html__('Progress Bar Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .skill-feature.style2 .progress" => "background: {{VALUE}}"
			]
		]);

		$this->add_control('progress_bar_active_color', [
            'label' => esc_html__('Progress Bar Active Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .skill-feature .progress .progress-bar" => "background: {{VALUE}}"
			]
		]);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		?>
		<div class="skill-feature style2 position-relative">
			<h3 class="skill-feature_title"><?php echo $settings['title']; ?></h3>
			<div class="progress">
				<div class="progress-bar" style="width: <?php echo $settings['value']; ?>%;"></div>
				<div class="progress-value"><span class="counter-number"><?php echo $settings['value']; ?></span>%</div>
			</div>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Line_Progress_Widget());
