<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Marquee extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-marquee-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Marquee', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image', [
                'label' => esc_html__('Image', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__('upload image', 'bizmaster-core'),
            ]
        );

		$repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Car Back Light', 'bizmaster-core'),
				'description' => esc_html__('type title', 'bizmaster-core'),
            ]
        );

		$repeater->add_control('marquee_style', [
			'label' => esc_html__('Marquee Style', 'bizmaster-core'),
			'type' => Controls_Manager::SELECT,
			'options' => array(
				'style-default' => esc_html__('Default', 'bizmaster-core'),
				'text-stroke' => esc_html__('Text Stroke', 'bizmaster-core')
			),
			'default' => 'style-default',
			'description' => esc_html__('Select Marquee Style', 'bizmaster-core')
		]);

		$repeater->add_control(
			'marquee_btn_url',
			[
				'label' => esc_html__( 'Marquee Url', 'bizmaster-core' ),
				'type' => Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'description' => esc_html__('enter url.', 'bizmaster-core'),
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false
				],
				'label_block' => true
			]
		);

		$this->add_control('marquee_items', [
			'label' => esc_html__('Marquee Items', 'bizmaster-core'),
			'type' => Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls()
		]);

		$this->end_controls_section();

		/*  tab styling tabs start */
		$this->start_controls_section(
			'style_settings_section',
			[
				'label' => esc_html__('Style Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control('title_color', [
			'label' => esc_html__('Title Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .slider__marquee .item a" => "color: {{VALUE}}",
				"{{WRAPPER}} .slider__marquee .item a span.text-stroke" => "-webkit-text-stroke-color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Title Typography', 'bizmaster-core'),
			'name' => 'title_typography',
			'description' => esc_html__('Title Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .slider__marquee .item a"
		]);

        $this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$marquee_items = $settings['marquee_items'];
		$rand_numb = rand(333, 999999999) . uniqid();
		?>
		<div class="marquee-area">
            <div class="container-fluid p-0 overflow-hidden">
                <div class="slider__marquee">
                    <div class="marquee_mode" id="marquee-slider-<?php echo esc_attr($rand_numb); ?>">
                        <?php foreach ($marquee_items as $index => $item): ?>
							<?php
								if ( ! empty( $item['marquee_btn_url']['url'] ) ) {
									$this->add_link_attributes( "marquee_btn_url{$index}", $item['marquee_btn_url'] );
								}
							?>
							<div class="item">
								<a <?php $this->print_render_attribute_string( "marquee_btn_url{$index}" ); ?>>
									<img src="<?php echo $item['image']['url']; ?>" alt="<?php echo $item['title']; ?>">
									<span class="<?php echo $item['marquee_style']; ?>"><?php echo $item['title']; ?></span>
								</a>
							</div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Marquee());
