<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Project_Grid_List_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-project-grid-list-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Project Grid List Two', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'bizmaster-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in grid list, enter -1 for unlimited post.')
        ]);

        $this->add_control('category', [
            'label' => esc_html__('Category', 'bizmaster-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => bizmaster_core()->get_terms_names('project-category', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'bizmaster-core'),
        ]);

        $this->add_control('order', [
            'label' => esc_html__('Order', 'bizmaster-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'bizmaster-core'),
                'DESC' => esc_html__('Descending', 'bizmaster-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'bizmaster-core')
        ]);

        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'bizmaster-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'bizmaster-core'),
                'title' => esc_html__('Title', 'bizmaster-core'),
                'date' => esc_html__('Date', 'bizmaster-core'),
                'rand' => esc_html__('Random', 'bizmaster-core'),
                'comment_count' => esc_html__('Most Comments', 'bizmaster-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'bizmaster-core')
        ]);

        $this->end_controls_section();


        //style tab start
        $this->start_controls_section(
            'title_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .portfolio-box .portfolio-box-details_subtitle" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'bizmaster-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .portfolio-box .portfolio-box-details_subtitle"
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .portfolio-box .portfolio-box-details_title a" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('title_hover_color', [
            'label' => esc_html__('Title Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .portfolio-box .portfolio-box-details_title a:hover" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'bizmaster-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .portfolio-box .portfolio-box-details_title a"
        ]);

        $this->add_control('btn_bg_color', [
            'label' => esc_html__('Button BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .portfolio-box .portfolio-box-details .icon-btn" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('btn_bg_hover_color', [
            'label' => esc_html__('Button BG Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .portfolio-box .portfolio-box-details .icon-btn:hover" => "background: {{VALUE}}"
            ]
        ]);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];

        //setup query
        $args = array(
            'post_type' => 'project',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1,
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'project-category',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>

     
        <div class="row">
        <?php 
            $i = 0;
            while ($post_data->have_posts()):$post_data->the_post();
            $i++; 

            //border condition here
            if($i < 3){
                $col_md_6 = 'col-md-6';
            }else {
                $col_md_6 = 'col-lg-4 col-md-6';
            }
            //image condition here
            $img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
            $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'project-image-2', false) : '';
            $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
            $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

            $comments_count = get_comments_number(get_the_ID());
            $comment_text = ($comments_count > 1) ? 'Comments (' . $comments_count . ')' : 'Comment (' . $comments_count . ')';

            $project_single_meta_data = get_post_meta(get_the_ID(), 'bizmaster_project_options', true);
            $project_subtitle = isset($project_single_meta_data['project_subtitle']) && !empty($project_single_meta_data['project_subtitle']) ? $project_single_meta_data['project_subtitle'] : '';

            // icon
            $project_icon = isset($project_single_meta_data['project_icon']) && !empty($project_single_meta_data['project_icon']) ? $project_single_meta_data['project_icon'] : '';
            ?>
            <!-- my -->
            <div class="<?php echo esc_attr($col_md_6); ?> col-md-auto filter-item">
                <div class="portfolio-box mb-4">
                    <div class="portfolio-box-thumb">
                        <img src="<?php echo esc_url($img_url); ?>" alt="img">
                    </div>
                    <div class="portfolio-box-details">
                        <div class="media-left">
                            <span class="portfolio-box-details_subtitle"><?php echo $project_subtitle;  ?></span>
                            <h4 class="portfolio-box-details_title"><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
                        </div>
                        <a href="<?php the_permalink(); ?>" class="icon-btn">
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="29" viewBox="0 0 28 29" fill="none">
                                <path d="M22.8613 7.54846L22.8903 16.0337C22.9263 16.8622 22.2326 17.5606 21.4039 17.5303C20.5754 17.5663 19.8769 16.8726 19.9072 16.0439L19.8574 11.1716L7.63552 23.4773C7.04094 24.076 6.11287 24.0791 5.51422 23.4846C4.8823 22.857 4.91239 21.9619 5.50697 21.3633L17.7289 9.05756L12.8897 9.07409C12.0611 9.11006 11.3627 8.41639 11.393 7.58764C11.357 6.75911 12.0507 6.06068 12.8795 6.091L21.3647 6.06201C22.1932 6.02604 22.8917 6.71971 22.8613 7.54846Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <!-- my -->
            <?php
                endwhile;
                wp_reset_query();
                ?>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Project_Grid_List_Two_Widget());