<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Project_Info_Widget extends Widget_Base
{
    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-project-info-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Project Info', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__('General Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control('title', [
			'label' => esc_html__('Title', 'bizmaster-core'),
			'type' => Controls_Manager::TEXT,
			'default' => esc_html__('Project Information', 'bizmaster-core')
		]);

		$this->add_control('content', [
			'label' => esc_html__('Content', 'bizmaster-core'),
			'type' => Controls_Manager::TEXTAREA,
			'default' => esc_html__('Aliquam eros justo, posuere loborti vive rra laoreet matti ullamc', 'bizmaster-core')
		]);

		$this->add_control('category', [
            'label' => esc_html__('Category', 'bizmaster-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Corporate, Business', 'bizmaster-core')
		]);

		$this->add_control('customer', [
			'label' => esc_html__('Customer', 'bizmaster-core'),
			'type' => Controls_Manager::TEXT,
			'default' => esc_html__('Starline Shimlasi', 'bizmaster-core')
		]);

		$this->add_control('start_date', [
			'label' => esc_html__('Start Date', 'bizmaster-core'),
			'type' => Controls_Manager::TEXT,
			'default' => esc_html__('21 January 2021', 'bizmaster-core')
		]);

        $this->add_control('end_date', [
			'label' => esc_html__('End Date', 'bizmaster-core'),
			'type' => Controls_Manager::TEXT,
			'default' => esc_html__('28 Sep 2023', 'bizmaster-core')
		]);

		$this->add_control('rating', [
			'label' => esc_html__('Rating', 'bizmaster-core'),
			'type' => Controls_Manager::SELECT,
			'options' => array(
				'1' => esc_html__('1 Star', 'bizmaster-core'),
				'2' => esc_html__('2 Star', 'bizmaster-core'),
				'3' => esc_html__('3 Star', 'bizmaster-core'),
				'4' => esc_html__('4 Star', 'bizmaster-core'),
				'5' => esc_html__('5 Star', 'bizmaster-core')
			),
			'default' => '5',
			'description' => esc_html__('Select rating', 'bizmaster-core')
		]);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			's_icon',
			[
				'label' => esc_html__('Icon', 'bizmaster-core'),
				'type' => Controls_Manager::ICONS,
				'description' => esc_html__('select Icon.', 'bizmaster-core'),
				'default' => [
					'value' => 'fas fa-phone-alt',
					'library' => 'solid'
				]
			]
		);

		$repeater->add_control(
			's_url',
			[
				'label' => esc_html__( 'Social Url', 'bizmaster-core' ),
				'type' => Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false
				],
				'label_block' => true
			]
		);

		$this->add_control('social_items', [
			'label' => esc_html__('Social Items', 'bizmaster-core'),
			'type' => Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls()
		]);

		$this->end_controls_section();

		/* styling tabs start */
		$this->start_controls_section(
            'project_info_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control('project_info_bg_color', [
            'label' => esc_html__('Info Card BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .widget_project-info" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_responsive_control(
			'project_info_padding',
			[
				'label'      => esc_html__('Info Card Padding', 'bizmaster-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .widget_project-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'project_info_border_radius',
			[
				'label'      => esc_html__('Info Card Border Radius', 'bizmaster-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .widget_project-info' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control('title_color', [
			'label' => esc_html__('Title Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .widget_project-info .widget_title" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Title Typography', 'bizmaster-core'),
			'name' => 'title_typography',
			'description' => esc_html__('Title Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .widget_project-info .widget_title"
		]);

		$this->add_control('content_color', [
			'label' => esc_html__('Content Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .widget_project-info .widget-text" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Content Typography', 'bizmaster-core'),
			'name' => 'content_typography',
			'description' => esc_html__('Content Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .widget_project-info .widget-text"
		]);

		$this->add_control('label_color', [
			'label' => esc_html__('Label Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .widget_project-info ul li strong" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Label Typography', 'bizmaster-core'),
			'name' => 'label_typography',
			'description' => esc_html__('Label Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .widget_project-info ul li strong"
		]);

		$this->add_control('value_color', [
			'label' => esc_html__('Value Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .widget_project-info ul li span" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Value Typography', 'bizmaster-core'),
			'name' => 'value_typography',
			'description' => esc_html__('Value Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .widget_project-info ul li span"
		]);

		$this->add_control('rating_color', [
			'label' => esc_html__('Rating Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'default' => '#FFB539',
			'selectors' => [
				"{{WRAPPER}} .widget_project-info ul li span.star-ratting" => "color: {{VALUE}}"
			]
		]);

		$this->add_control('social_icon_bg_color', [
			'label' => esc_html__('Social Icon BG Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .social-btn.style5 a" => "background: {{VALUE}}"
			]
		]);

		$this->add_control('social_icon_hover_bg_color', [
			'label' => esc_html__('Social Icon Hover BG Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .social-btn.style5 a:hover" => "background: {{VALUE}}"
			]
		]);

		$this->add_control('social_icon_color', [
			'label' => esc_html__('Social Icon Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .social-btn.style5 a" => "color: {{VALUE}}",
				"{{WRAPPER}} .social-btn.style5 a i" => "color: {{VALUE}}",
				"{{WRAPPER}} .social-btn.style5 a svg" => "color: {{VALUE}}; fill: {{VALUE}}"
			]
		]);

		$this->add_control('social_icon_hover_color', [
			'label' => esc_html__('Social Icon Hover Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .social-btn.style5 a:hover" => "color: {{VALUE}}",
				"{{WRAPPER}} .social-btn.style5 a:hover i" => "color: {{VALUE}}",
				"{{WRAPPER}} .social-btn.style5 a:hover svg" => "color: {{VALUE}}; fill: {{VALUE}}"
			]
		]);

		$this->add_control('social_icon_border_color', [
			'label' => esc_html__('Social Icon Border Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .social-btn.style5 a" => "border-color: {{VALUE}}"
			]
		]);

		$this->add_control('social_icon_hover_border_color', [
			'label' => esc_html__('Social Icon Hover Border Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .social-btn.style5 a:hover" => "border-color: {{VALUE}}"
			]
		]);

		$this->add_control(
			'social_icon_border_radius',
			[
				'label'      => esc_html__('Social Icon Border Radius', 'bizmaster-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .social-btn.style5 a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$rating = $settings['rating'];
		$social_items = $settings['social_items'];
		?>
		<aside class="sidebar-area">
			<div class="widget_project-info">
				<h3 class="widget_title"><?php echo $settings['title']; ?></h3>
				<p class="widget-text"><?php echo $settings['content']; ?></p>
				<ul>
					<li>
						<strong><?php _e( 'Category:', 'bizmaster-core' ); ?> </strong>
						<span><?php echo $settings['category']; ?></span>
					</li>
					<li>
						<strong><?php _e( 'Customer:', 'bizmaster-core' ); ?> </strong>
						<span><?php echo $settings['customer']; ?></span>
					</li>
					<li>
						<strong><?php _e( 'Start Date:', 'bizmaster-core' ); ?> </strong>
						<span><?php echo $settings['start_date']; ?></span>
					</li>
					<li>
						<strong><?php _e( 'End Date:', 'bizmaster-core' ); ?> </strong>
                        <span><?php echo $settings['end_date']; ?></span>
                    </li>
                    <li>
						<strong><?php _e( 'Rating:', 'bizmaster-core' ); ?> </strong>
						<span>
							<span class="star-ratting">
							<?php for($i = 0; $i < $rating; $i++){ ?>
								<i class="fas fa-star"></i>
							<?php } ?>
							</span>
						</span>
					</li>
				</ul>
			</div>
			<div class="social-btn style5 justify-content-start mt-4">
				<?php foreach ($social_items as $index => $s_item) : ?>
					<?php
						if ( ! empty( $s_item['s_url']['url'] ) ) {
							$this->add_link_attributes( "s_url{$index}", $s_item['s_url'] );
						}
					?>
					<a tabindex="-1" <?php $this->print_render_attribute_string( "s_url{$index}" ); ?>>
						<?php Icons_Manager::render_icon($s_item['s_icon'], ['aria-hidden' => 'true']); ?>
					</a>
				<?php endforeach; ?>
			</div>
		</aside>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Project_Info_Widget());
