<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Service_Grid_List_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-service-grid-list-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Service Grid List One', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control('service_grid', [
            'label' => esc_html__('Service Grid', 'bizmaster-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'col-lg-3' => esc_html__('col-lg-2', 'bizmaster-core'),
                'col-lg-3' => esc_html__('col-lg-3', 'bizmaster-core'),
                'col-lg-4' => esc_html__('col-lg-4', 'bizmaster-core'),
                'col-lg-6' => esc_html__('col-lg-6', 'bizmaster-core'),
            ),
            'default' => 'col-lg-6',
            'description' => esc_html__('Select Case Study Grid', 'bizmaster-core')
        ]);

        $this->add_control(
            'read_more',
            [
                'label' => esc_html__('Read More Show/Hide', 'bizmaster-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'bizmaster-core'),
                'default' => 'yes',
            ]
        );

        $this->add_control('read-btn', [
            'label' => esc_html__('Read More', 'bizmaster-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter read button text', 'bizmaster-core'),
            'default' => esc_html__('Read More', 'bizmaster-core'),
            'condition' => ['read_more' => 'yes'],
        ]);

        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'bizmaster-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in grid list, enter -1 for unlimited post.')
        ]);

        $this->add_control('category', [
            'label' => esc_html__('Category', 'bizmaster-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => bizmaster_core()->get_terms_names('service-category', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'bizmaster-core'),
        ]);

        $this->add_control('order', [
            'label' => esc_html__('Order', 'bizmaster-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'bizmaster-core'),
                'DESC' => esc_html__('Descending', 'bizmaster-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'bizmaster-core')
        ]);

        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'bizmaster-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'bizmaster-core'),
                'title' => esc_html__('Title', 'bizmaster-core'),
                'date' => esc_html__('Date', 'bizmaster-core'),
                'rand' => esc_html__('Random', 'bizmaster-core'),
                'comment_count' => esc_html__('Most Comments', 'bizmaster-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('Select Order', 'bizmaster-core')
        ]);

		$this->end_controls_section();

        //style tab start
        $this->start_controls_section(
            'title_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .service-card_title a" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('title_hover_color', [
            'label' => esc_html__('Title Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .service-card_title a:hover" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'bizmaster-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .service-card_title"
        ]);

        $this->add_control('content_color', [
            'label' => esc_html__('Content Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .service-card_text" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Content Typography', 'bizmaster-core'),
            'name' => 'content_typography',
            'description' => esc_html__('Content Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .service-card_text"
        ]);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

		//query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];

        //setup query
        $args = array(
            'post_type' => 'service',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1
		);

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'service-category',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }

        $post_data = new \WP_Query($args);
        ?>
        <!-- my -->
        <div class="service-area-1">
            <div class="row gx-30 gy-30 justify-content-center">
            <?php while ($post_data->have_posts()):$post_data->the_post(); 

                
                //image condition here
                $img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
                $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'bizmaster_grid_service_12', false) : '';
                $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

                $comments_count = get_comments_number(get_the_ID());
                $comment_text = ($comments_count > 1) ? 'Comments (' . $comments_count . ')' : 'Comment (' . $comments_count . ')';

                $service_single_meta_data = get_post_meta(get_the_ID(), 'bizmaster_service_options', true);
                $service_icon = isset($service_single_meta_data['service_icon']) && !empty($service_single_meta_data['service_icon']) ? $service_single_meta_data['service_icon'] : '';

                $service_details = isset($service_single_meta_data['service_content']) && !empty($service_single_meta_data['service_content']) ? $service_single_meta_data['service_content'] : '';
                ?>
                <div class="<?php echo esc_attr($settings['service_grid']); ?> col-md-6">
                    <div class="service-card">
                        <div class="service-card_img">
                            <img src="<?php echo esc_url($img_url) ?>" alt="img">
                        </div>
                        <div class="service-card_content">
                            <h4 class="service-card_title"><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
                            <p class="service-card_text"><?php echo $service_details; ?> </p>
							<?php if(!empty($settings['read-btn'])) { ?>
								<a href="<?php the_permalink(); ?>" class="link-btn"><?php echo esc_html($settings['read-btn']); ?> <i class="fas fa-arrow-right"></i></a>
							<?php } ?>
                        </div>
                    </div>
                </div>
                <?php
                endwhile;
                wp_reset_query();
                ?>
            </div>
        </div>
        
        <!-- my -->
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Service_Grid_List_One_Widget());