<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Tab_Widget extends Widget_Base
{
    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-tab-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('BizMaster Tab', 'bizmaster-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Tab', 'Title', "HugeBinary", 'Bizmaster'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-tabs';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__('General Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'tab_name',
			[
				'label' => esc_html__('Title', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Biography', 'bizmaster-core')
			]
		);

		$repeater->add_control(
            'tab_text_type',
            [
                'label' => esc_html__('Content Type', 'bizmaster-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'content' => esc_html__('Content', 'bizmaster-core'),
                    'template' => esc_html__('Saved Templates', 'bizmaster-core'),
                ],
                'default' => 'content',
            ]
        );

        $repeater->add_control(
            'primary_templates',
            [
				'label' => esc_html__('Choose Template', 'bizmaster-core'),
				'type' => Controls_Manager::SELECT2,
				'multiple' => false,
				'options' => bizmaster_core()->get_post_names('elementor_library', 'publish'),
				'description' => esc_html__('select template as you want.', 'bizmaster-core'),
				'condition' => [
                    'tab_text_type' => 'template',
                ],
            ]
        );

		$repeater->add_control(
            'tab_content',
            [
                'label' => esc_html__('Tab Content', 'bizmaster-core'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipisicing elit. Optio, neque qui velit. Magni dolorum quidem ipsam eligendi, totam, facilis laudantium cum accusamus ullam voluptatibus commodi numquam, error, est. Ea, consequatur.', 'essential-addons-for-elementor-lite'),
                'dynamic' => ['active' => true],
                'condition' => [
                    'tab_text_type' => 'content',
                ],
            ]
        );

		$this->add_control('list_items', [
			'label' => esc_html__('List Items', 'bizmaster-core'),
			'type' => Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls()
		]);

		$this->end_controls_section();

		$this->start_controls_section(
			'styling_section',
			[
				'label' => esc_html__('Styling Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control('tab_btn_bg_color', [
            'label' => esc_html__('Tab BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .goal-tabs-wrapper .nav-tabs.goal-tabs-tabs .nav-link" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('tab_btn_color', [
            'label' => esc_html__('Tab Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .goal-tabs-wrapper .nav-tabs.goal-tabs-tabs .nav-link" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_control('tab_btn_border_color', [
			'label' => esc_html__('Tab Border Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .goal-tabs-wrapper .nav-tabs.goal-tabs-tabs .nav-link" => "border-color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Tab Nav Typography', 'bizmaster-core'),
			'name' => 'btn_typography',
			'description' => esc_html__('Tab Nav Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .goal-tabs-wrapper .nav-tabs.goal-tabs-tabs .nav-link"
		]);

		$this->add_control('tab_btn_hover_bg_color', [
            'label' => esc_html__('Tab Hover BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .goal-tabs-wrapper .nav-tabs.goal-tabs-tabs .nav-link:hover" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('tab_btn_hover_color', [
			'label' => esc_html__('Tab Hover Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .goal-tabs-wrapper .nav-tabs.goal-tabs-tabs .nav-link:hover" => "color: {{VALUE}}"
			]
		]);

		$this->add_control('tab_btn_hover_border_color', [
			'label' => esc_html__('Tab Hover Border Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .goal-tabs-wrapper .nav-tabs.goal-tabs-tabs .nav-link:hover" => "border-color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Tab Nav Hover Typography', 'bizmaster-core'),
			'name' => 'btn_hover_typography',
			'description' => esc_html__('Tab Nav Hover Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .goal-tabs-wrapper .nav-tabs.goal-tabs-tabs .nav-link:hover"
		]);

		$this->add_control('tab_btn_active_bg_color', [
            'label' => esc_html__('Tab Active BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .goal-tabs-wrapper .nav-tabs.goal-tabs-tabs .nav-link.active" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('tab_btn_active_color', [
			'label' => esc_html__('Tab Active Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .goal-tabs-wrapper .nav-tabs.goal-tabs-tabs .nav-link.active" => "color: {{VALUE}}"
			]
		]);

		$this->add_control('tab_btn_active_border_color', [
			'label' => esc_html__('Tab Active Border Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .goal-tabs-wrapper .nav-tabs.goal-tabs-tabs .nav-link.active" => "border-color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Tab Nav Active Typography', 'bizmaster-core'),
			'name' => 'btn_active_typography',
			'description' => esc_html__('Tab Nav Active Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .goal-tabs-wrapper .nav-tabs.goal-tabs-tabs .nav-link.active"
		]);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$list_items = $settings['list_items'];
		$biz_uniqid = uniqid();
		?>
		<div class="goal-area">
			<div class="container">
				<div class="row">
					<div class="goal-tabs-wrapper">
						<div class="nav nav-tabs goal-tabs-tabs" id="nav-tab" role="tablist">
							<?php $i = 1; ?>
							<?php foreach ($list_items as $item): ?>
								<?php
									if($i == 1) {
										$active = 'active';
									} else {
										$active = '';
									}
								?>
								<button class="nav-link <?php echo $active; ?>" id="nav-<?php echo $i .'-'. $biz_uniqid .'-'. strtolower($item['tab_name']); ?>-tab" data-bs-toggle="tab" data-bs-target="#nav-<?php echo $i .'-'. $biz_uniqid .'-'. strtolower($item['tab_name']); ?>" type="button"><?php echo $item['tab_name']; ?></button>
								<?php $i++; ?>
							<?php endforeach; ?>
						</div>
						<div class="tab-content" id="nav-<?php echo $biz_uniqid; ?>-tabContent">
							<?php $j = 1; ?>
							<?php foreach ($list_items as $item): ?>
								<?php
									if($j == 1) {
										$active2 = 'active show';
									} else {
										$active2 = '';
									}
								?>
								<div class="tab-pane fade <?php echo $active2; ?>" id="nav-<?php echo $j .'-'. $biz_uniqid .'-'. strtolower($item['tab_name']); ?>" role="tabpanel">
									<?php if ('content' == $item['tab_text_type']) : ?>
										<?php echo $this->parse_text_editor( $item['tab_content'] ); ?>
									<?php elseif ('template' == $item['tab_text_type']) : ?>
										<?php if ( ! empty( $item['primary_templates'] ) ) { ?>
											<?php echo Plugin::$instance->frontend->get_builder_content_for_display( $item['primary_templates'] ); ?>
										<?php } ?>
									<?php endif; ?>
								</div>
								<?php $j++; ?>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Tab_Widget());
