<?php
/**
 * Elementor Widget
 * @package bizmaster
 * @since 1.0.0
 */

namespace Elementor;

class Bizmaster_Team_Details_Info_Widget extends Widget_Base
{

    /**
     * Get widget name.
     * 
     * Retrieve Elementor widget name.
     * 
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-team-details-info-widget';
    }

    /**
     * Get widget title.
     * 
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Team Details Info', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-person';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Team Member Details', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'main_image', [
                'label' => esc_html__('Team Member Image', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Upload Member Image', 'bizmaster-core'),
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				]
			]
		);

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Member Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Biography', 'bizmaster-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'count_title',
            [
                'label' => esc_html__('Count Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Design', 'bizmaster-core'),
            ]
        );

        $repeater->add_control(
            'count_value',
            [
                'label' => esc_html__('Count Value', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('80', 'bizmaster-core'),
            ]
        );

        $this->add_control('team_progress_items', [
            'label' => esc_html__('Team Progress Items', 'bizmaster-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls()
        ]);

        $this->add_control(
            'content_one',
            [
                'label' => esc_html__('Content One', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('This category focuses on the design and construction of buildings and the This category focuses on the design and construction of buildings and arrangement of furniture and decorative elements within themarrangement', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'content_two',
            [
                'label' => esc_html__('Content Two', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('This category focuses on the design and construction of buildings and the This category focuses on the design and construction of buildings', 'bizmaster-core'),
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
            'team_member_details_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-about-card_box h3.team-about-card_title" => "color: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'bizmaster-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .team-about-card_box h3.team-about-card_title"
        ]);

		$this->add_control('progress_items_title_color', [
            'label' => esc_html__('Progress Items Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-about-card_box .skill-feature h3.skill-feature_title" => "color: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Progress Items Title Typography', 'bizmaster-core'),
            'name' => 'progress_items_title_typography',
            'description' => esc_html__('Progress Items Title Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .team-about-card_box .skill-feature h3.skill-feature_title"
        ]);

		$this->add_control('progress_items_value_color', [
            'label' => esc_html__('Progress Items Value Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-about-card_box .skill-feature .progress .progress-value" => "color: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Progress Items Value Typography', 'bizmaster-core'),
            'name' => 'progress_items_value_typography',
            'description' => esc_html__('Progress Items Value Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .team-about-card_box .skill-feature .progress .progress-value"
        ]);

		$this->add_control('progress_items_bar_bg_color', [
			'label' => esc_html__('Progress Items Bar BG Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
                "{{WRAPPER}} .team-about-card_box .skill-feature .progress" => "background: {{VALUE}}",
            ]
        ]);

		$this->add_control('progress_items_bar_color', [
            'label' => esc_html__('Progress Items Value Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
			'selectors' => [
                "{{WRAPPER}} .team-about-card_box .skill-feature .progress .progress-bar" => "background: {{VALUE}}",
            ]
        ]);

		$this->add_control('member_content_one_color', [
            'label' => esc_html__('Member Content One Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-about-card_box p.content-one" => "color: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Member Content One Typography', 'bizmaster-core'),
            'name' => 'member_content_one_typography',
            'description' => esc_html__('Member Content One Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .team-about-card_box p.content-one"
        ]);

		$this->add_control('member_content_two_color', [
            'label' => esc_html__('Member Content Two Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-about-card_box p.content-two" => "color: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Member Content Two Typography', 'bizmaster-core'),
            'name' => 'member_content_two_typography',
            'description' => esc_html__('Member Content Two Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .team-about-card_box p.content-two"
        ]);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display(); 
        $team_progress_items = $settings['team_progress_items'];
        ?>

        <div class="team-about-card mb-0">
            <div class="row g-lg-0">
                <div class="col-lg-6">
                    <div class="team-about-card_img">
						<?php if(!empty($settings['main_image']['url'])) { ?>
							<img class="w-100" src="<?php echo $settings['main_image']['url']; ?>" alt="team image">
						<?php } else { ?>
							<img class="w-100" src="<?php echo Utils::get_placeholder_image_src(); ?>" alt="team image">
						<?php } ?>
                    </div>
                </div>

                <div class="col-lg-6 align-self-center">
                    <div class="team-about-card_box">
                        <?php if($settings['title']) : ?>
                            <h3 class="team-about-card_title"><?php echo $settings['title']; ?></h3>
                        <?php endif; ?>

                        <?php foreach ($team_progress_items as $team_progress_item) : ?>
                            <div class="skill-feature position-relative">
								<?php if(!empty($team_progress_item['count_title'])) { ?>
									<h3 class="skill-feature_title"><?php echo $team_progress_item['count_title']; ?></h3>
								<?php } ?>
								<div class="progress">
                                    <div class="progress-bar" style="width: <?php echo $team_progress_item['count_value']; ?>%;"></div>
									<div class="progress-value"><span class="counter-number"><?php echo $team_progress_item['count_value']; ?></span>%</div>
                                </div>
                            </div>
                        <?php endforeach; ?>

                        <?php if($settings['content_one']) : ?>
                            <p class="content-one"><?php echo $settings['content_one']; ?></p>
                        <?php endif; ?>
                        <?php if($settings['content_two']) : ?>
                            <p class="mb-n2 content-two"><?php echo $settings['content_two']; ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Team_Details_Info_Widget());
