<?php
/**
 * Elementor Widget
 * @package bizmaster
 * @since 1.0.0
 */

namespace Elementor;

class Bizmaster_Team_Slider_Three_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-team-slider-three-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Team Slider Three', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-person';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control('total', [
            'label' => esc_html__('Total Posts', 'bizmaster-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in slider, enter -1 for unlimited post.')
        ]);

		$this->add_control('category', [
            'label' => esc_html__('Category', 'bizmaster-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => bizmaster()->get_terms_names('team-category', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'bizmaster-core'),
        ]);

        $this->add_control('order', [
            'label' => esc_html__('Order', 'bizmaster-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'bizmaster-core'),
                'DESC' => esc_html__('Descending', 'bizmaster-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'bizmaster-core')
        ]);

		$this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'bizmaster-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'bizmaster-core'),
                'title' => esc_html__('Title', 'bizmaster-core'),
                'date' => esc_html__('Date', 'bizmaster-core'),
                'rand' => esc_html__('Random', 'bizmaster-core'),
                'comment_count' => esc_html__('Most Comments', 'bizmaster-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'bizmaster-core')
        ]);

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Slides To Show', 'bizmaster-core'),
                'type' => Controls_Manager::NUMBER,
                'description' => esc_html__('you can set how many item show in slider', 'bizmaster-core'),
                'default' => '3',
            ]
        );

		$this->add_control(
            'dots',
            [
                'label' => esc_html__('Dots', 'bizmaster-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'bizmaster-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'bizmaster-core'),
            ]
        );

		$this->add_control(
            'center',
            [
                'label' => esc_html__('Center', 'bizmaster-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'bizmaster-core'),

            ]
        );

		$this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'bizmaster-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'bizmaster-core'),
            ]
        );

		$this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'bizmaster-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 500,
                        'max' => 10000,
                        'step' => 100,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'team_member_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control('team_card_bg_color', [
            'label' => esc_html__('Team Card BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-slider3 .team-card" => "background-color: {{VALUE}}"
            ]
        ]);

		$this->add_control('share_icon_bg_color', [
            'label' => esc_html__('Share Icon BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-slider3 .team-card .team-social .plus-btn" => "background-color: {{VALUE}}"
            ]
        ]);

		$this->add_control('share_icon_color', [
            'label' => esc_html__('Share Icon Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
			'default' => '#19352D',
			'selectors' => [
                "{{WRAPPER}} .team-slider3 .team-card .team-social .plus-btn svg" => "fill: {{VALUE}}"
            ]
        ]);

        $this->add_control('social_share_icons_bg_color', [
            'label' => esc_html__('Social Share Icons BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-slider3 .team-card .global-social" => "background-color: {{VALUE}}"
            ]
        ]);

        $this->add_control('social_share_icon_color', [
            'label' => esc_html__('Social Share Icon Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-slider3 .team-social .global-social a" => "color: {{VALUE}}",
            ]
        ]);

		$this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-slider3 .team-card h4.team-card_title a" => "color: {{VALUE}}",
            ]
        ]);

        $this->add_control('title_hover_color', [
            'label' => esc_html__('Title Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-slider3 .team-card h4.team-card_title a:hover" => "color: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'bizmaster-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .team-slider3 .team-card h4.team-card_title a"
        ]);

		$this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-slider3 .team-card .team-card_desig" => "color: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'bizmaster-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .team-slider3 .team-card .team-card_desig"
        ]);

		$this->add_control('slick_dots_bg_color', [
            'label' => esc_html__('Slick Dots BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
			'default' => '#54595F',
            'selectors' => [
                "{{WRAPPER}} .team-slider3 .slick-dots" => "background-color: {{VALUE}}",
            ]
        ]);

        $this->add_control('slick_active_dot_bg_color', [
            'label' => esc_html__('Slick Active Dot BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-slider3 .slick-dots .slick-active button" => "background-color: {{VALUE}}",
            ]
        ]);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
		$rand_numb = rand(333, 999999999);

		//slider settings
		$slider_settings = [
			"dots" => esc_attr($settings['dots']),
			"loop" => esc_attr($settings['loop']),
            "items" => esc_attr($settings['items'] ? $settings['items'] : 1),
            "center" => esc_attr($settings['center']),
            "autoplay" => esc_attr($settings['autoplay']),
			"autoplaytimeout" => esc_attr(!empty($settings['autoplaytimeout']['size']) ? $settings['autoplaytimeout']['size'] : 0)
		];

		//query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];

        //setup query
        $args = array(
            'post_type' => 'team',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish'
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'team-category',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
		?>
		<div id="team-three-carousel-<?php echo esc_attr($rand_numb); ?>" data-settings='<?php echo json_encode($slider_settings) ?>' class="row gx-30 team-slider3">
			<?php
			while ($post_data->have_posts()) : $post_data->the_post();
				$post_id = get_the_ID();
				$img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
				$img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full', false) : '';
				$img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
				$img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
				$team_single_meta_data = get_post_meta($post_id, 'bizmaster_team_options', true);
				$social_icons = isset($team_single_meta_data['social-icons']) && !empty($team_single_meta_data['social-icons']) ? $team_single_meta_data['social-icons'] : '';
			?>
				<div class="col-lg-4">
					<div class="team-card style2">
						<div class="team-card_img">
							<img src="<?php echo esc_url($img_url) ?>" alt="<?php echo $img_alt; ?>">
						</div>
						<div class="team-card_wrapp">
							<div class="team-card_content">
								<h4 class="team-card_title"><a href="<?php the_permalink() ?>"><?php echo esc_html(get_the_title($post_id)) ?></a></h4>
								<span class="team-card_desig"><?php echo $team_single_meta_data['designation'] ?></span>
							</div>
							<div class="team-social">
								<div class="plus-btn">
									<svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M12.75 3.25C12.75 4.69922 11.5742 5.875 10.125 5.875C9.41406 5.875 8.75781 5.60156 8.29297 5.16406L5.72266 6.44922C5.72266 6.53125 5.72266 6.64062 5.72266 6.75C5.72266 6.85938 5.72266 6.96875 5.72266 7.07812L8.29297 8.36328C8.75781 7.92578 9.41406 7.625 10.125 7.625C11.5742 7.625 12.75 8.80078 12.75 10.25C12.75 11.6992 11.5742 12.875 10.125 12.875C8.64844 12.875 7.5 11.6992 7.5 10.25C7.5 10.1406 7.5 10.0312 7.5 9.94922L4.92969 8.66406C4.46484 9.10156 3.80859 9.375 3.125 9.375C1.64844 9.375 0.5 8.19922 0.5 6.75C0.5 5.30078 1.64844 4.125 3.125 4.125C3.80859 4.125 4.46484 4.42578 4.92969 4.86328L7.5 3.57812C7.5 3.46875 7.5 3.35938 7.5 3.25C7.5 1.80078 8.64844 0.625 10.125 0.625C11.5742 0.625 12.75 1.80078 12.75 3.25ZM3.09766 7.625C3.58984 7.625 3.97266 7.24219 3.97266 6.75C3.97266 6.28516 3.58984 5.875 3.09766 5.875C2.63281 5.875 2.22266 6.28516 2.22266 6.75C2.22266 7.24219 2.63281 7.625 3.09766 7.625ZM10.125 2.375C9.63281 2.375 9.25 2.78516 9.25 3.25C9.25 3.74219 9.63281 4.125 10.125 4.125C10.5898 4.125 11 3.74219 11 3.25C11 2.78516 10.5898 2.375 10.125 2.375ZM10.125 11.125C10.5898 11.125 11 10.7422 11 10.25C11 9.78516 10.5898 9.375 10.125 9.375C9.63281 9.375 9.25 9.78516 9.25 10.25C9.25 10.7422 9.63281 11.125 10.125 11.125Z" />
									</svg>
								</div>
								<div class="global-social">
									<?php
										if (!empty($social_icons)) {
											foreach ($social_icons as $item) {
												printf('<a href="%1$s"><i class="%2$s"></i></a>', $item['url'], $item['icon']);
											}
										}
									?> 
								</div>
							</div>
						</div>
					</div>
				</div>
			<?php endwhile; ?>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Team_Slider_Three_Widget());
