<?php
/**
 * Elementor Widget
 * @package bizmaster
 * @since 1.0.0
 */

namespace Elementor;

class Bizmaster_Testimonial_Slider_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-testimonial-slider-one';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonial Slider One', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'image', [
				'label' => esc_html__('Main Image', 'bizmaster-core'),
				'type' => Controls_Manager::MEDIA,
				'show_label' => false,
				'description' => esc_html__('Upload Main Image', 'bizmaster-core')
			]
		);

		$repeater->add_control(
			'content', [
				'label' => esc_html__('Content', 'bizmaster-core'),
				'type' => Controls_Manager::TEXTAREA,
				'show_label' => false,
				'default' => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.'),
				'description' => esc_html__('Upload Content', 'bizmaster-core')
			]
		);

		$repeater->add_control(
			'name', [
			'label' => esc_html__('Name', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Jhon Suria', 'bizmaster-core'),
				'show_label' => true,
				'description' => esc_html__('enter name', 'bizmaster-core')
			]
		);

		$repeater->add_control(
			'designation', [
				'label' => esc_html__('Designation', 'bizmaster-core'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Marketing Coordinator', 'bizmaster-core'),
				'description' => esc_html__('enter designation', 'bizmaster-core')
			]
		);

        $repeater->add_control(
			'rating', [
				'label' => esc_html__('Rating', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('5', 'bizmaster-core')
			]
		);

        $this->add_control('testimonial_items', [
			'label' => esc_html__('Testimonial Slider Item', 'bizmaster-core'),
			'type' => Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls(),
			'default' => [
				[
					'image' => array('url' => Utils::get_placeholder_image_src())
				]
			]
		]);

        $this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' => esc_html__('Slider Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);

        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'bizmaster-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'bizmaster-core'),
            ]
        );

		$this->add_control(
            'center',
            [
                'label' => esc_html__('Center', 'bizmaster-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'bizmaster-core'),

            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'bizmaster-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'bizmaster-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 500,
                        'max' => 10000,
                        'step' => 100,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]
        );

		$this->add_control(
			'nav',
			[
				'label' => esc_html__('Nav', 'bizmaster-core'),
				'type' => Controls_Manager::SWITCHER,
				'description' => esc_html__('you can set yes/no to enable/disable', 'bizmaster-core'),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'nav_left_arrow',
			[
				'label' => esc_html__('Nav Left Icon', 'bizmaster-core'),
				'type' => Controls_Manager::ICONS,
				'description' => esc_html__('upload the nav left icon', 'bizmaster-core'),
				'default' => [
					'value' => 'fas fa-angle-left',
					'library' => 'solid'
				],
				'condition' => ['nav' => 'yes']
			]
		);

		$this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'bizmaster-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('upload the nav right icon', 'bizmaster-core'),
				'default' => [
					'value' => 'fas fa-angle-right',
					'library' => 'solid'
				],
				'condition' => ['nav' => 'yes']
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
            'testimonial_one_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control('quote_icon_color', [
			'label' => esc_html__('Quote Icon Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'default' => '#196164',
			'selectors' => [
				"{{WRAPPER}} .testi-card .quote-icon svg" => "color: {{VALUE}}; fill: {{VALUE}}"
			]
		]);

		$this->add_control('rating_color', [
			'label' => esc_html__('Rating Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .testi-card .rating" => "color: {{VALUE}}"
			]
		]);

		$this->add_control('content_color', [
			'label' => esc_html__('Content Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .testi-card .testi-card_text" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Content Typography', 'bizmaster-core'),
			'name' => 'content_typography',
			'description' => esc_html__('Content Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .testi-card .testi-card_text"
		]);

		$this->add_control(
			'testi_image_border_radius',
			[
				'label'      => esc_html__('Image Border Radius', 'bizmaster-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .testi-card .testi-card-profile .testi-profile_thumb img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control('name_color', [
			'label' => esc_html__('Name Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .testi-card .testi-card-profile .testi-profile-title" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Name Typography', 'bizmaster-core'),
			'name' => 'name_typography',
			'description' => esc_html__('Name Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .testi-card .testi-card-profile .testi-profile-title"
		]);

		$this->add_control('designation_color', [
			'label' => esc_html__('Designation Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .testi-card .testi-card-profile .testi-profile-desig" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Designation Typography', 'bizmaster-core'),
			'name' => 'designation_typography',
			'description' => esc_html__('Designation Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .testi-card .testi-card-profile .testi-profile-desig"
		]);

		$this->add_control('nav_icons_bg_color', [
            'label' => esc_html__('Navigation Icons BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-slider-one .slider-nav .slick-arrow" => "background: {{VALUE}}"
            ]
        ]);

        $this->add_control('nav_icon_color', [
            'label' => esc_html__('Navigation Icon Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-slider-one .slider-nav .slick-arrow" => "color: {{VALUE}}; fill: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'testimonial_slider_one_border',
				'label'    => esc_html__('Border', 'bizmaster-core'),
				'selector' => '{{WRAPPER}} .testimonial-slider-one .slider-nav .slick-arrow'
			]
		);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
	protected function render() {

		$settings = $this->get_settings_for_display();
		$all_testimonial_items = $settings['testimonial_items'];
		$rand_numb = rand(333, 999999999);

		//slider settings
		$slider_settings = [
			"loop" => esc_attr($settings['loop']),
			"items" => 1,
			"center" => esc_attr($settings['center']),
			"autoplay" => esc_attr($settings['autoplay']),
			"autoplaytimeout" => esc_attr(!empty($settings['autoplaytimeout']['size']) ? $settings['autoplaytimeout']['size'] : 0),
			"nav" => esc_attr($settings['nav']),
			"navleft" => bizmaster_core()->render_elementor_icons($settings['nav_left_arrow']),
			"navright" => bizmaster_core()->render_elementor_icons($settings['nav_right_arrow'])
		];
		?>
		<div class="testimonial-slider-one testi-area-slider bizmaster-rtl-slider">
			<div class="testimonial-slider" id="testimonial-slider-one-carousel-<?php echo esc_attr($rand_numb); ?>" data-settings='<?php echo json_encode($slider_settings) ?>'>
				<?php foreach ($all_testimonial_items as $testimonial_item): ?>
					<div class="testi-card">
						<div class="testi-card_content">
							<div class="rating">
								<?php for ($i=0; $i < $testimonial_item['rating']; $i++) { ?>
									<i class="fa fa-star"></i>
								<?php } ?>
							</div>
							<p class="testi-card_text"><?php echo esc_html($testimonial_item['content']); ?></p>
							<div class="testi-card-profile">
								<div class="testi-profile_thumb">
									<img src="<?php echo $testimonial_item['image']['url']; ?>" alt="<?php echo esc_html($testimonial_item['name']); ?>">
								</div>
								<div class="testi-card-profile-details">
									<h4 class="testi-profile-title"><?php echo esc_html($testimonial_item['name']); ?></h4>
									<span class="testi-profile-desig"><?php echo esc_html($testimonial_item['designation']); ?></span>
								</div>
							</div>
						</div>
						<div class="quote-icon">
                            <svg width="143" height="100" viewBox="0 0 453 410" fill="none" xmlns="http://www.w3.org/2000/svg">
								<g opacity="0.07">
									<path d="M261.211 234.385H358.479C356.673 255.362 347.071 274.901 331.568 289.146C316.064 303.392 295.785 311.31 274.731 311.339C272.853 311.339 271.053 312.084 269.726 313.412C268.398 314.739 267.653 316.54 267.653 318.417V363.972C267.653 365.849 268.398 367.649 269.726 368.977C271.053 370.304 272.853 371.05 274.731 371.05C354.006 371.05 418.487 306.568 418.487 227.307V77.1094C418.487 75.2321 417.742 73.4318 416.414 72.1044C415.087 70.777 413.286 70.0312 411.409 70.0312H261.211C259.334 70.0312 257.534 70.777 256.206 72.1044C254.879 73.4318 254.133 75.2321 254.133 77.1094V227.307C254.133 229.184 254.879 230.985 256.206 232.312C257.534 233.64 259.334 234.385 261.211 234.385ZM268.29 84.1875H404.331V227.307C404.331 296.39 349.999 353.015 281.809 356.695V325.24C332.672 321.602 372.933 279.062 372.933 227.307C372.933 225.43 372.187 223.63 370.859 222.302C369.532 220.975 367.732 220.229 365.854 220.229H268.29V84.1875ZM48.9385 234.385H146.22C144.418 255.363 134.817 274.904 119.313 289.15C103.808 303.396 83.5273 311.313 62.4719 311.339C60.5946 311.339 58.7943 312.084 57.4669 313.412C56.1395 314.739 55.3937 316.54 55.3937 318.417V363.972C55.3937 365.849 56.1395 367.649 57.4669 368.977C58.7943 370.304 60.5946 371.05 62.4719 371.05C141.747 371.05 206.229 306.568 206.229 227.307V77.1094C206.229 75.2321 205.483 73.4318 204.155 72.1044C202.828 70.777 201.028 70.0312 199.15 70.0312H48.9385C47.0612 70.0312 45.2609 70.777 43.9335 72.1044C42.6061 73.4318 41.8604 75.2321 41.8604 77.1094V227.307C41.8604 229.184 42.6061 230.985 43.9335 232.312C45.2609 233.64 47.0612 234.385 48.9385 234.385ZM56.0166 84.1875H192.072V227.307C192.072 296.39 137.726 353.015 69.55 356.695V325.24C120.413 321.602 160.66 279.062 160.66 227.307C160.66 225.43 159.914 223.63 158.586 222.302C157.259 220.975 155.459 220.229 153.581 220.229H56.0166V84.1875Z" />
								</g>
							</svg>
						</div>
					</div>
				<?php endforeach; ?>
			</div> 
			<?php if (!empty($settings['nav'])) : ?>
				<div class="slick-carousel-controls nav-wrapper">
					<div class="slider-nav"></div>
				</div>
			<?php endif; ?>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Testimonial_Slider_One_Widget());
