<?php

/**
 * Elementor Addons Init
 * @package bizmaster
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit(); // exit if access directly
}


if ( ! class_exists( 'Bizmaster_Elementor_Widget_Init' ) ) {

	class Bizmaster_Elementor_Widget_Init {
	   /**
		* $instance
		* @since 1.0.0
		*/
		private static $instance;

	   /**
		* construct()
		* @since 1.0.0
		*/
		public function __construct() {
			add_action( 'elementor/elements/categories_registered', array( $this, '_widget_categories' ) );
			//elementor widget registered
			add_action( 'elementor/widgets/widgets_registered', array( $this, '_widget_registered' ) );
			// elementor editor css
			add_action( 'elementor/editor/after_enqueue_scripts', array( $this, 'load_assets_for_elementor' ) );
			//add icon to elementor new icons fileds
			add_filter( 'elementor/icons_manager/native', array( $this, 'add_custom_icon_to_elementor_icons' ) );
			//enable elementor editor for service, project, team post types
			add_action('init', array($this, '_enable_elementor_editor'));
		}

		/**
	     * getInstance()
	     * @since 1.0.0
	     */
		public static function getInstance() {
			if ( null == self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * _widget_categories()
		 * @since 1.0.0
		 */
		public function _widget_categories( $elements_manager ) {
			$elements_manager->add_category(
				'bizmaster_widgets',
				[
					'title' => esc_html__( 'Bizmaster Widgets', 'bizmaster-core' ),
					'icon'  => 'fas fa-plug',
				]
			);
		}

		/**
		 * _widget_registered()
		 * @since 1.0.0
		 */
		public function _widget_registered() {
			if ( ! class_exists( 'Elementor\Widget_Base' ) ) {
				return;
			}
			$elementor_widgets = array(
				'heading-title',
				'banner-one',
				'banner-two',
				'banner-three',
				'service-grid-list-one',
				'service-grid-list-two',
				'service-slider',
				'work-process',
				'project-grid-list-one',
				'project-grid-list-two',
				'project-grid-list-three',
				'team-slider-one',
				'team-slider-two',
				'team-slider-three',
				'team-grid',
				'team-member-info',
				'testimonial-slider-one',
				'testimonial-slider-two',
				'marquee',
				'pricing-one',
				'career',
				'blog-slider-one',
				'blog-slider-two',
				'blog-slider-three',
				'cta',
				'about',
				'tab',
				'accordion',
				'service-category',
				'project-info',
				'about-img',
				'line-progress',
				'feature',
				'contact',
				'team-details-info',
			);


			$elementor_widgets = apply_filters( 'bizmaster_elementor_widget', $elementor_widgets );
			ksort( $elementor_widgets );
			if ( is_array( $elementor_widgets ) && ! empty( $elementor_widgets ) ) {
				foreach ( $elementor_widgets as $widget ) {
					if ( file_exists( BIZMASTER_CORE_ELEMENTOR . '/addons/elementor-' . $widget . '-widget.php' ) ) {
						require_once BIZMASTER_CORE_ELEMENTOR . '/addons/elementor-' . $widget . '-widget.php';
					}
				}
			}
		}

		/**
         * Enable Elementor Editor for service, project, team Post Types
         * @since  1.0.1
         */
        public function _enable_elementor_editor()
        {
			$cpt_support = get_option( 'elementor_cpt_support' );
			//check if option DOESN'T exist in db
			if( ! $cpt_support ) {
				$cpt_support = [ 'page', 'post', 'service', 'project', 'team' ]; //create array of our default supported post types
				update_option( 'elementor_cpt_support', $cpt_support ); //write it to the database
			} else {
				//check if service post type not exist in db
				if ( ! in_array( 'service', $cpt_support ) ) {
					$cpt_support[] = 'service'; //append to array
					update_option( 'elementor_cpt_support', $cpt_support ); //update database
				}

				//check if project post type not exist in db
				if ( ! in_array( 'project', $cpt_support ) ) {
					$cpt_support[] = 'project'; //append to array
					update_option( 'elementor_cpt_support', $cpt_support ); //update database
				}

				//check if team post type not exist in db
				if ( ! in_array( 'team', $cpt_support ) ) {
					$cpt_support[] = 'team'; //append to array
					update_option( 'elementor_cpt_support', $cpt_support ); //update database
				}
			}
		}

		public function add_custom_icon_to_elementor_icons( $icons ) {
			$icons['flaticon'] = [
				'name'          => 'flaticon',
				'label'         => esc_html__( 'Flaticon', 'bizmaster-core' ),
				'url'           => BIZMASTER_CORE_CSS . '/flaticon.css',
				// icon css file
				'enqueue'       => [ BIZMASTER_CORE_CSS . '/flaticon.css' ],
				// icon css file
				'prefix'        => 'flaticon-',
				//prefix ( like fas-fa  )
				'displayPrefix' => '',
				//prefix to display icon
				'labelIcon'     => 'flaticon-karate-1',
				//tab icon of elementor icons library
				'ver'           => '1.0.0',
				'fetchJson'     => BIZMASTER_CORE_JS . '/flaticon.js',
				//json file with icon list example {"icons: ['icon class']}
				'native'        => true,
			];

			return $icons;
		}

		/**
		 * load custom assets for elementor
		 * @since 1.0.0
		*/
		public function load_assets_for_elementor() {
			wp_enqueue_style( 'flaticon', BIZMASTER_CORE_CSS . '/flaticon.css' );
			wp_enqueue_style( 'bizmaster-core-elementor-style', BIZMASTER_CORE_ADMIN_ASSETS . '/css/elementor-editor.css' );
		}
	}

	if ( class_exists( 'Bizmaster_Elementor_Widget_Init' ) ) {
		Bizmaster_Elementor_Widget_Init::getInstance();
	}
}//end if
