<?php
/**
 * Theme Taxonomy Options
 * @package Bizmaster
 * @since 1.0.0
 */

if ( !defined('ABSPATH') ){
	exit(); // exit if access directly
}

if ( class_exists('CSF') ){

	$allowed_html = bizmaster_core()->kses_allowed_html(array('mark'));

	$prefix = 'bizmaster';

    /**
     * Service Category Options
     * @package bizmaster
     * @since 1.0.0
     */

	CSF::createTaxonomyOptions( $prefix .'_service_category', array(
		'taxonomy'  => 'service-category',
		'data_type' => 'serialize', // The type of the database save options. `serialize` or `unserialize`
	) );

	// Create a section
	CSF::createSection( $prefix .'_service_category', array(
		'fields' => array(
			array(
				'id'    => 'icon',
				'type'  => 'icon',
				'title' => esc_html__('Icon','bizmaster'),
				'default' => 'flaticon-businessman'
			),
		)
	) );


    /**
     * project Category Options
     * @package bizmaster
     * @since 1.0.0
     */
    CSF::createTaxonomyOptions( $prefix .'_project_category', array(
        'taxonomy'  => 'project-category',
        'data_type' => 'serialize', // The type of the database save options. `serialize` or `unserialize`
    ) );

    // Create a section
    CSF::createSection( $prefix .'_project_category', array(
        'fields' => array(
            array(
                'id'    => 'icon',
                'type'  => 'icon',
                'title' => esc_html__('Icon','bizmaster'),
                'default' => 'flaticon-suitcase'
            ),
        )
    ) );

    /**
     * Team Category Options
     * @package bizmaster
     * @since 1.0.0
     */
    CSF::createTaxonomyOptions( $prefix .'_team_category', array(
        'taxonomy'  => 'team-category',
        'data_type' => 'serialize', // The type of the database save options. `serialize` or `unserialize`
    ) );

    // Create a section
    CSF::createSection( $prefix .'_team_category', array(
        'fields' => array(
            array(
                'id'    => 'icon',
                'type'  => 'icon',
                'title' => esc_html__('Icon','bizmaster'),
                'default' => 'flaticon-suitcase'
            ),
        )
    ) );

}//endif