<?php
/**
 * Theme Excerpt Class
 * @package bizmaster
 * @since 1.0.0
 */

if (!defined('ABSPATH')){
	exit(); //exit if access it directly
}

if (!class_exists('Bizmaster_Core_excerpt')):
class Bizmaster_Core_excerpt {

    public static $length = 55;
	public static $more = '...';
	public static $types = array(
      'short' => 25,
      'regular' => 55,
      'long' => 100,
      'promo' => 15
    );

    /**
     * Sets the length for the excerpt
     * @package bizmaster
     */ 
    public static function length($new_length = 55, $more = '...') {
		Bizmaster_Core_excerpt::$length = $new_length;
        Bizmaster_Core_excerpt::$more = $more;

        add_filter( 'excerpt_more', 'Bizmaster_Core_excerpt::auto_excerpt_more' );
        add_filter('excerpt_length', 'Bizmaster_Core_excerpt::new_length');
        Bizmaster_Core_excerpt::output();
	}

    public static function new_length() {
        if( isset(Bizmaster_Core_excerpt::$types[Bizmaster_Core_excerpt::$length]) )
            return Bizmaster_Core_excerpt::$types[Bizmaster_Core_excerpt::$length];
        else
            return Bizmaster_Core_excerpt::$length;
    }

    public static function output() {
        the_excerpt();
    }

    public static function auto_excerpt_more( ) {
		return Bizmaster_Core_excerpt::$more;
	}

} //end class
endif;

if (!function_exists('Bizmaster_Core_excerpt')){
	function Bizmaster_Core_excerpt($length = 55, $more = '...') {
		Bizmaster_Core_excerpt::length($length, $more);
	}
}
?>