<?php
/**
 * Theme Core Init
 * @package bizmaster
 * @since 1.0.0
 */

if (!defined("ABSPATH")) {
	exit(); //exit if access directly
}

if (!class_exists('Bizmaster_Core_Init')) {

	class Bizmaster_Core_Init
	{
	   /**
        * $instance
        * @since 1.0.0
        */
		protected static $instance;

		public function __construct()
		{
			//Load plugin assets
			add_action('wp_enqueue_scripts', array($this, 'plugin_assets'));
			//Load plugin admin assets
			add_action('admin_enqueue_scripts', array($this, 'admin_assets'));
			//load plugin text domain
			add_action('init', array($this, 'load_textdomain'));
			//add custom icon to codester framework
			add_filter('csf_field_icon_add_icons', array($this, 'csf_custom_icon'));
			//load plugin dependency files()
            add_action('plugin_loaded', array($this, 'load_plugin_dependency_files'));
		}

	   /**
        * getInstance()
        * @since 1.0.0
        */
		public static function getInstance()
		{
			if (null == self::$instance) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * Load Plugin Text domain
		 * @since 1.0.0
		 */
		public function load_textdomain()
		{
			load_plugin_textdomain('bizmaster-core', false, BIZMASTER_CORE_ROOT_PATH . '/languages');
		}

		/**
		 * Load plugin dependency files()
		 * @since 1.0.0
		 */
		public function load_plugin_dependency_files()
		{
			$includes_files = array(
				array(
					'file-name' => 'codestar-framework',
					'folder-name' => BIZMASTER_CORE_LIB . '/codestar-framework'
				),
				array(
					'file-name' => 'theme-menu-page',
					'folder-name' => BIZMASTER_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-custom-post-type',
					'folder-name' => BIZMASTER_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-post-column-customize',
					'folder-name' => BIZMASTER_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-bizmaster-core-excerpt',
					'folder-name' => BIZMASTER_CORE_INC
				),
				array(
					'file-name' => 'csf-taxonomy',
					'folder-name' => BIZMASTER_CORE_INC
				),
				array(
					'file-name' => 'theme-core-shortcodes',
					'folder-name' => BIZMASTER_CORE_INC
				),
				array(
					'file-name' => 'elementor-widget-init',
					'folder-name' => BIZMASTER_CORE_ELEMENTOR
				),
                array(
                    'file-name' => 'theme-social-share-widget',
                    'folder-name' => BIZMASTER_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-about-me-widget',
                    'folder-name' => BIZMASTER_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-about-us-widget',
                    'folder-name' => BIZMASTER_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-search-widget',
                    'folder-name' => BIZMASTER_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-tags-menu',
                    'folder-name' => BIZMASTER_CORE_WP_WIDGETS
                ),
				array(
					'file-name' => 'theme-recent-post-widget',
					'folder-name' => BIZMASTER_CORE_WP_WIDGETS
				),
				array(
					'file-name' => 'theme-recent-post-title-widget',
					'folder-name' => BIZMASTER_CORE_WP_WIDGETS
				),
				array(
					'file-name' => 'theme-contact-info-widget',
					'folder-name' => BIZMASTER_CORE_WP_WIDGETS
				),
                array(
                    'file-name' => 'theme-service-category-widget',
                    'folder-name' => BIZMASTER_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-request-form-widget',
                    'folder-name' => BIZMASTER_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-category-widget',
                    'folder-name' => BIZMASTER_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-discover-company-widget',
                    'folder-name' => BIZMASTER_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-file-download-widget',
                    'folder-name' => BIZMASTER_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-author-widget',
                    'folder-name' => BIZMASTER_CORE_WP_WIDGETS
                ),
				array(
					'file-name' => 'theme-demo-data-import',
					'folder-name' => BIZMASTER_CORE_DEMO_IMPORT
				),
			);

            if (defined('ELEMENTOR_VERSION')) {
                $includes_files[] = array(
                    'file-name' => 'theme-elementor-icon-manager',
                    'folder-name' => BIZMASTER_CORE_INC
                );
            }
			if (is_array($includes_files) && !empty($includes_files)) {
				foreach ($includes_files as $file) {
					if (file_exists($file['folder-name'] . '/' . $file['file-name'] . '.php')) {
						require_once $file['folder-name'] . '/' . $file['file-name'] . '.php';
					}
				}
			}
		}

		/**
		 * Admin assets
		 * @since 1.0.0
		 */
		public function plugin_assets()
		{
			self::load_plugin_css_files();
			self::load_plugin_js_files();
		}

		/**
		 * Load plugin css files()
		 * @since 1.0.0
		 */
		public function load_plugin_css_files()
		{
			$plugin_version = BIZMASTER_CORE_VERSION;
			$all_css_files = array(
				array(
					'handle' => 'fontawesome',
					'src' => BIZMASTER_CORE_CSS . '/font-awesome.min.css',
					'deps' => array(),
					'ver' => '5.12.0',
					'media' => 'all'
				),
				array(
					'handle' => 'magnific-popup',
					'src' => BIZMASTER_CORE_CSS . '/magnific-popup.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
                array(
                    'handle' => 'odometer',
                    'src' => BIZMASTER_CORE_CSS . '/odometer.css',
                    'deps' => array(),
                    'ver' => $plugin_version,
                    'media' => 'all'
                ),
                array(
                    'handle' => 'slick',
                    'src' => BIZMASTER_CORE_CSS . '/slick.css',
                    'deps' => array(),
                    'ver' => $plugin_version,
                    'media' => 'all'
                ),
				array(
					'handle' => 'bizmaster-core-main-style',
					'src' => BIZMASTER_CORE_CSS . '/main-style.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				)
			);
			
			if (!bizmaster_core()->is_bizmaster_active()) {
				$all_css_files[] = array(
					'handle' => 'animate',
					'src' => BIZMASTER_CORE_CSS . '/animate.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'bootstrap',
					'src' => BIZMASTER_CORE_CSS . '/bootstrap.min.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'font-awesome',
					'src' => BIZMASTER_CORE_CSS . '/font-awesome.min.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'bizmaster-main-style',
					'src' => BIZMASTER_CORE_CSS . '/theme-style.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'bizmaster-responsive',
					'src' => BIZMASTER_CORE_CSS . '/theme-responsive.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
			}
			$all_css_files = apply_filters('bizmaster_core_css', $all_css_files);

			if (is_array($all_css_files) && !empty($all_css_files)) {
				foreach ($all_css_files as $css) {
					call_user_func_array('wp_enqueue_style', $css);
				}
			}
		}

		/**
		 * Load plugin js
		 * @since 1.0.0
		 */
		public function load_plugin_js_files()
		{
			// all js files
			wp_enqueue_script( 'countdown', BIZMASTER_CORE_JS . '/jquery.countdown.min.js', array('jquery'), '1.0.6', true );
			wp_enqueue_script( 'nice-select', BIZMASTER_CORE_JS . '/jquery.nice-select.js', array('jquery'), '1.0.6', true );
			wp_enqueue_script( 'isotope', BIZMASTER_CORE_JS . '/isotope.pkgd.min.js', array('jquery'), '1.0.6', true );
			wp_enqueue_script( 'imagesloaded', BIZMASTER_CORE_JS . '/imagesloaded.pkgd.min.js', array('jquery'), '1.6.2', true );
			wp_enqueue_script( 'counter-up', BIZMASTER_CORE_JS . '/counter-up.min.js', array('jquery'), '1.1.3', true );
			wp_enqueue_script( 'waypoints', BIZMASTER_CORE_JS . '/wow.min.js', array('jquery'), '4.0.1', true );
			wp_enqueue_script( 'viewport', BIZMASTER_CORE_JS . '/viewport.jquery.js', array('jquery'), '1.0.4', true );
			wp_enqueue_script( 'slick', BIZMASTER_CORE_JS . '/slick.min.js', array('jquery'), '1.0.4', true );
			wp_enqueue_script( 'marquee', BIZMASTER_CORE_JS . '/jquery.marquee.min.js', array('jquery'), '1.0.4', true );
			wp_enqueue_script( 'bizmaster-core-main-script', BIZMASTER_CORE_JS . '/main.js', array('jquery'), time(), true );
		}

		/**
		 * Admin assets
		 * @since 1.0.0
		 */
		public function admin_assets()
		{
			self::load_admin_css_files();
			self::load_admin_js_files();
		}

		/**
		 * Load plugin admin css files()
		 * @since 1.0.0
		 */
		public function load_admin_css_files()
		{
			$plugin_version = BIZMASTER_CORE_VERSION;
			$all_css_files = array(
				array(
					'handle' => 'bizmaster-core-admin-style',
					'src' => BIZMASTER_CORE_ADMIN_ASSETS . '/css/admin.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
				array(
					'handle' => 'flaticon',
					'src' => BIZMASTER_CORE_CSS . '/flaticon.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
			);

			$all_css_files = apply_filters('bizmaster_admin_css', $all_css_files);
			if (is_array($all_css_files) && !empty($all_css_files)) {
				foreach ($all_css_files as $css) {
					call_user_func_array('wp_enqueue_style', $css);
				}
			}
		}

		/**
		 * Load plugin admin js
		 * @since 1.0.0
		 */
		public function load_admin_js_files()
		{
			wp_enqueue_script( 'bizmaster-core-widget', BIZMASTER_CORE_ADMIN_ASSETS . '/js/widget.js', array('jquery'), '1.0.6', true );
		}

		/**
		 * Add Custom Icon To Codester Framework
		 * @since 1.0.0
		 */
		public function csf_custom_icon($icons)
		{
			//adding new icon
			$icons[]  = array(
				'title' => esc_html__('Flaticon', 'bizmaster-core'),
				'icons' => array(
					'flaticon-right-arrow',
					'flaticon-running',
					'flaticon-stationery-bicycle',
					'flaticon-boxing-gloves',
					'flaticon-kickboxing',
					'flaticon-right-arrow-1',
					'flaticon-share',
					'flaticon-facebook',
					'flaticon-twitter',
					'flaticon-google-plus',
					'flaticon-instagram',
					'flaticon-consultation',
					'flaticon-customer',
					'flaticon-trainer',
					'flaticon-team',
					'flaticon-straight-quotes',
					'flaticon-star',
					'flaticon-telephone-call',
					'flaticon-volume',
					'flaticon-qualified',
					'flaticon-fit',
					'flaticon-fighting',
					'flaticon-karate',
					'flaticon-judo',
					'flaticon-kickboxing-1',
					'flaticon-karate-1',
					'flaticon-wrestling',
					'flaticon-karate-2',
					'flaticon-karate-3',
					'flaticon-taekwondo',
					'flaticon-check',
					'flaticon-email',
					'flaticon-badge',
					'flaticon-placeholder',
					'flaticon-boxing',
					'flaticon-boxing-1',
					'flaticon-boxing-2',
					'flaticon-location',
					'flaticon-phone-call',
					'flaticon-quote',
					'flaticon-good-shape',
					'flaticon-man',
					'flaticon-fitness',
					'flaticon-star-1',
					'flaticon-whistle',
					'flaticon-boxing-glove',
					'flaticon-magnifying-glass',
					'flaticon-mission',
					'flaticon-focus',
					'flaticon-mission-1',
					'flaticon-arroba',
					'flaticon-clock-circular-outline',
					'flaticon-calendar',
					'flaticon-stopwatch',
					'flaticon-maps-and-flags',
					'flaticon-slim-down',
					'flaticon-heart',
					'flaticon-flag',
					'flaticon-document',
					'flaticon-expand',
					'flaticon-red-eye',
					'flaticon-group',
					'flaticon-writing',
					'flaticon-id-card',
					'flaticon-calendar-1',
					'flaticon-calendar-2',
					'flaticon-right-arrow-2',
					'flaticon-right-arrows',
					'flaticon-next',
					'flaticon-next-1',
					'flaticon-right-arrow-3',
					'flaticon-arrow',
					'flaticon-left-arrow',
					'flaticon-arrow-1',
					'flaticon-youtube'
				)
			);

			$icons = array_reverse($icons);

			return $icons;
		}
	} //end class
	if (class_exists('Bizmaster_Core_Init')) {
		Bizmaster_Core_Init::getInstance();
	}
}
