<?php
/**
 * Theme File Download Widget
 * @package Bizmaster
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('bizmaster_file_download_widget', array(
        'title' => esc_html__('Bizmaster: File Download', 'bizmaster-core'),
        'classname' => 'bizmaster-widget-file-download',
        'description' => esc_html__('Display File Download widget', 'bizmaster-core'),
        'fields' => array(
            array(
                'id' => 'title',
                'type' => 'text',
                'title' => esc_html__('Title', 'Bizmaster-core'),
                'default' => esc_html__('Download', 'bizmaster-core')
            ),

            array(
                'id' => 'bizmaster-file-download-repeater',
                'type' => 'repeater',
                'title' => esc_html__('File Download', 'bizmaster-core'),
                'fields' => array(
                    array(
                        'id' => 'bizmaster-file-download',
                        'type' => 'media',
                        'title' => esc_html__('File', 'bizmaster-core'),
                    ),
                    array(
                        'id' => 'bizmaster-file-download-text',
                        'type' => 'text',
                        'title' => esc_html__('File Text', 'bizmaster-core'),
                        'default' => esc_html__('Company Profile', 'bizmaster-core')
                    ),

                ),
            ),
        )
    ));


    if (!function_exists('bizmaster_file_download_widget')) {
        function bizmaster_file_download_widget($args, $instance)
        {

            echo $args['before_widget'];

            $title = $instance['title'] ?? '';
            $file_download = is_array($instance['bizmaster-file-download-repeater']) && !empty($instance['bizmaster-file-download-repeater']) ? $instance['bizmaster-file-download-repeater'] : [];


            ?>
            <div class="widget_download">
                <h5 class="widget-headline style-01"><?php echo esc_html($title); ?></h5>               
                <ul>
                    <?php
                        foreach ($file_download as $file) {
                            echo '<li class="mb-0 mt-0">
                                <a download href="'.$file['bizmaster-file-download']['url'].'">
                                    ' . $file['bizmaster-file-download-text'] . '
                                    <i class="fa fa-angle-double-right"></i>
                                </a>
                            </li>';
                        };
                    ?>
                </ul>
            </div>
            <?php

            echo $args['after_widget'];

        }
    }

}

?>